/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.threerings.config.ConfigManager;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.CrowdClientResolver;
import com.threerings.media.image.ColorPository;
import com.threerings.presents.client.Client;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.BootstrapData;
import com.threerings.presents.server.ClientResolutionListener;
import com.threerings.presents.server.ClientResolver;
import com.threerings.presents.server.LocalDObjectMgr;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.PresentsSession;
import com.threerings.presents.server.SessionFactory;
import com.threerings.resource.ResourceManager;
import com.threerings.tudey.Log;
import com.threerings.tudey.data.TudeyBodyObject;
import com.threerings.tudey.server.TudeyServer;
import com.threerings.tudey.tools.ToolSceneConfig;
import com.threerings.tudey.tools.ToolSceneRepository;
import com.threerings.util.Name;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.server.WhirledSession;
import com.threerings.whirled.server.persist.SceneRepository;

@Singleton
public class ToolServer
extends TudeyServer {
    @Inject
    protected Client _client;
    @Inject
    protected ResourceManager _rsrcmgr;
    @Inject
    protected ConfigManager _cfgmgr;
    @Inject
    protected ColorPository _colorpos;
    @Inject
    protected ToolSceneRepository _scenerepo;

    public ResourceManager getResourceManager() {
        return this._rsrcmgr;
    }

    public ConfigManager getConfigManager() {
        return this._cfgmgr;
    }

    public ColorPository getColorPository() {
        return this._colorpos;
    }

    public ToolSceneRepository getSceneRepository() {
        return this._scenerepo;
    }

    public void init(Injector injector) throws Exception {
        super.init(injector);
        this._clmgr.setDefaultSessionFactory(new SessionFactory(){

            public Class<? extends PresentsSession> getSessionClass(AuthRequest areq) {
                return WhirledSession.class;
            }

            public Class<? extends ClientResolver> getClientResolverClass(Name username) {
                return ToolClientResolver.class;
            }
        });
    }

    public void startStandaloneClient(Name username) {
        ClientResolutionListener clr = new ClientResolutionListener(){

            public void clientResolved(Name username, ClientObject clobj) {
                String[] groups = ToolServer.this._client.prepareStandaloneLogon();
                BootstrapData data = new BootstrapData();
                data.clientOid = clobj.getOid();
                data.services = ToolServer.this._invmgr.getBootstrapServices(groups);
                ToolServer.this._client.standaloneLogon(data, ((LocalDObjectMgr)ToolServer.this._omgr).getClientDObjectMgr(clobj.getOid()));
            }

            public void resolutionFailed(Name username, Exception cause) {
                Log.log.warning((Object)"Failed to resolve client.", new Object[]{"who", username, cause});
            }
        };
        this._clmgr.resolveClientObject(username, clr);
    }

    public void stopStandaloneClient() {
        this._client.standaloneLogoff();
    }

    protected static class ToolClientResolver
    extends CrowdClientResolver {
        protected ToolClientResolver() {
        }

        public ClientObject createClientObject() {
            return new TudeyBodyObject();
        }
    }

    public static class ToolModule
    extends TudeyServer.TudeyModule {
        protected Client _client;

        public ToolModule(Client client) {
            this._client = client;
        }

        protected void configure() {
            super.configure();
            this.bind(TudeyServer.class).to(ToolServer.class);
            this.bind(PresentsDObjectMgr.class).to(LocalDObjectMgr.class);
            this.bind(Client.class).toInstance((Object)this._client);
            this.bind(SceneRepository.class).to(ToolSceneRepository.class);
            this.bind(SceneRegistry.ConfigFactory.class).toInstance((Object)new SceneRegistry.ConfigFactory(){

                public PlaceConfig createPlaceConfig(SceneModel model) {
                    return new ToolSceneConfig();
                }
            });
        }

        protected boolean shouldInitConfigManager() {
            return false;
        }
    }
}

