/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.samskivert.swing.GroupLayout;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.QuickSort;
import com.threerings.editor.Editable;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.editors.ArrayListEditor;
import com.threerings.export.Exportable;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.tudey.Log;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.Layers;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.util.DeepObject;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class GlobalEditor
extends EditorTool
implements ChangeListener,
ActionListener,
TudeySceneModel.LayerObserver {
    protected EditorPanel _epanel;
    protected JFileChooser _chooser;
    protected HashIntMap<TudeySceneModel.GlobalEntry> _globals = new HashIntMap();
    protected boolean _ignoreAdd;
    protected boolean _ignoreUpdate;
    protected boolean _ignoreRemove;
    protected static Preferences _prefs = Preferences.userNodeForPackage(GlobalEditor.class);

    public GlobalEditor(SceneEditor editor, Layers layers) {
        super(editor);
        this._epanel = new EditorPanel(editor);
        this.add((Component)((Object)this._epanel));
        this._epanel.addChangeListener(this);
        JPanel xpanel = new JPanel();
        this.add((Component)xpanel, GroupLayout.FIXED);
        xpanel.add(ToolUtil.createButton(this, this._msgs, "import_short"));
        xpanel.add(ToolUtil.createButton(this, this._msgs, "export_short"));
        layers.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                GlobalEditor.this.updateShownGlobals();
            }
        });
        this._chooser = new JFileChooser(_prefs.get("global_export_dir", null));
        this._chooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return GlobalEditor.this._msgs.get("m.xml_files");
            }
        });
    }

    public void edit(TudeySceneModel.GlobalEntry entry) {
        int idx = ((EditableGlobals)this._epanel.getObject()).getIndex(entry.getId());
        if (idx != -1) {
            ((ArrayListEditor)this._epanel.getPropertyEditor("globals")).makeVisible(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent event) {
        this._editor.incrementEditId();
        EditableGlobals editable = (EditableGlobals)this._epanel.getObject();
        Predicate<TudeySceneModel.Entry> layerPredicate = this._editor.getLayerPredicate();
        Iterator it = this._globals.intEntrySet().iterator();
        while (it.hasNext()) {
            IntMap.IntEntry entry = (IntMap.IntEntry)it.next();
            int id = entry.getIntKey();
            TudeySceneModel.GlobalEntry oglobal = (TudeySceneModel.GlobalEntry)entry.getValue();
            if (!layerPredicate.apply((Object)oglobal)) continue;
            TudeySceneModel.GlobalEntry nglobal = editable.getGlobal(id);
            if (nglobal == null) {
                this._ignoreRemove = true;
                try {
                    this._editor.removeEntries(id);
                }
                finally {
                    this._ignoreRemove = false;
                }
                it.remove();
                continue;
            }
            if (nglobal.equals(oglobal)) continue;
            TudeySceneModel.GlobalEntry cglobal = (TudeySceneModel.GlobalEntry)nglobal.clone();
            this._ignoreUpdate = true;
            try {
                this._editor.updateEntries(cglobal);
            }
            finally {
                this._ignoreUpdate = false;
            }
            entry.setValue((Object)cglobal);
        }
        for (TudeySceneModel.GlobalEntry nglobal : editable.globals) {
            if (nglobal.getId() != 0) continue;
            TudeySceneModel.GlobalEntry cglobal = (TudeySceneModel.GlobalEntry)nglobal.clone();
            this._ignoreAdd = true;
            try {
                this._editor.addEntries(cglobal);
            }
            finally {
                this._ignoreAdd = false;
            }
            int id = cglobal.getId();
            this._globals.put(id, (Object)cglobal);
            nglobal.setId(id);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("import_short")) {
            this.importGlobals();
        } else {
            this.exportGlobals();
        }
    }

    public boolean allowsMouseCamera() {
        return true;
    }

    public void sceneChanged(TudeySceneModel scene) {
        super.sceneChanged(scene);
        this._globals.clear();
        for (TudeySceneModel.Entry entry : scene.getEntries()) {
            if (!(entry instanceof TudeySceneModel.GlobalEntry)) continue;
            TudeySceneModel.GlobalEntry global = (TudeySceneModel.GlobalEntry)entry;
            this._globals.put(global.getId(), (Object)global);
        }
        this.updateShownGlobals();
    }

    public void entryAdded(TudeySceneModel.Entry entry) {
        if (this._ignoreAdd || !(entry instanceof TudeySceneModel.GlobalEntry)) {
            return;
        }
        TudeySceneModel.GlobalEntry gentry = (TudeySceneModel.GlobalEntry)entry;
        int id = gentry.getId();
        this._globals.put(id, (Object)gentry);
        if (this._editor.getLayerPredicate().apply((Object)entry)) {
            EditableGlobals editable = (EditableGlobals)this._epanel.getObject();
            editable.globals = (TudeySceneModel.GlobalEntry[])ArrayUtil.append((Object[])editable.globals, (Object)((TudeySceneModel.GlobalEntry)entry.clone()));
            QuickSort.sort((Comparable[])editable.globals);
            this._epanel.update();
        }
    }

    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        if (this._ignoreUpdate || !(oentry instanceof TudeySceneModel.GlobalEntry)) {
            return;
        }
        TudeySceneModel.GlobalEntry entry = (TudeySceneModel.GlobalEntry)nentry;
        int id = entry.getId();
        this._globals.put(id, (Object)entry);
        EditableGlobals editable = (EditableGlobals)this._epanel.getObject();
        int idx = editable.getIndex(id);
        if (idx != -1) {
            entry.copy(editable.globals[idx]);
            this._epanel.update();
        }
    }

    public void entryRemoved(TudeySceneModel.Entry oentry) {
        if (this._ignoreRemove || !(oentry instanceof TudeySceneModel.GlobalEntry)) {
            return;
        }
        int id = ((TudeySceneModel.GlobalEntry)oentry).getId();
        this._globals.remove(id);
        EditableGlobals editable = (EditableGlobals)this._epanel.getObject();
        int idx = editable.getIndex(id);
        if (idx != -1) {
            editable.globals = (TudeySceneModel.GlobalEntry[])ArrayUtil.splice((Object[])editable.globals, (int)idx, (int)1);
            this._epanel.update();
        }
    }

    public void entryLayerWasSet(Object key, int layer) {
        if (this._ignoreUpdate || this._ignoreAdd || this._ignoreRemove) {
            return;
        }
        if (this._globals.containsKey(key)) {
            this.updateShownGlobals();
        }
    }

    protected void updateShownGlobals() {
        EditableGlobals editable = new EditableGlobals();
        editable.globals = (TudeySceneModel.GlobalEntry[])Iterables.toArray((Iterable)Iterables.filter((Iterable)this._globals.values(), this._editor.getLayerPredicate()), TudeySceneModel.GlobalEntry.class);
        QuickSort.sort((Comparable[])editable.globals);
        this._epanel.setObject(editable.clone());
    }

    protected void importGlobals() {
        if (this._chooser.showOpenDialog(this._editor.getFrame()) == 0) {
            File file = this._chooser.getSelectedFile();
            try {
                XMLImporter in = new XMLImporter(new FileInputStream(file));
                TudeySceneModel.Entry[] entries = (TudeySceneModel.GlobalEntry[])in.readObject();
                this._editor.incrementEditId();
                this._editor.addEntries(entries);
                in.close();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to import globals.", new Object[]{"file", file, e});
            }
        }
        _prefs.put("global_export_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void exportGlobals() {
        if (this._chooser.showSaveDialog(this._editor.getFrame()) == 0) {
            File file = this._chooser.getSelectedFile();
            try {
                XMLExporter out = new XMLExporter(new FileOutputStream(file));
                out.writeObject(Iterables.toArray((Iterable)Iterables.filter((Iterable)this._globals.values(), this._editor.getVisiblePredicate()), TudeySceneModel.GlobalEntry.class));
                out.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to export globals.", new Object[]{"file", file, e});
            }
        }
        _prefs.put("global_export_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected static class EditableGlobals
    extends DeepObject
    implements Exportable {
        @Editable
        public TudeySceneModel.GlobalEntry[] globals;

        protected EditableGlobals() {
        }

        public TudeySceneModel.GlobalEntry getGlobal(int id) {
            int idx = this.getIndex(id);
            return idx == -1 ? null : this.globals[idx];
        }

        public int getIndex(int id) {
            for (int ii = 0; ii < this.globals.length; ++ii) {
                if (this.globals[ii].getId() != id) continue;
                return ii;
            }
            return -1;
        }
    }
}

