/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.threerings.editor.Editable;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform2D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.tudey.client.util.ShapeConfigElement;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.util.DeepObject;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Eraser
extends EditorTool
implements ChangeListener {
    protected Options _options = new Options();
    protected ShapeConfigElement _cursor;
    protected boolean _cursorVisible;
    protected float _angle;
    protected Transform2D _transform = new Transform2D(1);
    protected Shape _shape;
    protected Vector3f _isect = new Vector3f();
    protected ArrayList<TudeySceneModel.Entry> _entries = new ArrayList();

    public Eraser(SceneEditor editor) {
        super(editor);
        ShapeConfig.Rectangle rect = (ShapeConfig.Rectangle)this._options.shape;
        rect.width = 0.99f;
        rect.height = 0.99f;
        EditorPanel epanel = new EditorPanel(editor);
        this.add((Component)((Object)epanel));
        epanel.setObject(this._options);
        epanel.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent event) {
        this._options.shape.invalidate();
        this._cursor.setConfig(this._options.shape, true);
    }

    public void init() {
        this._cursor = new ShapeConfigElement(this._editor);
        this._cursor.setConfig(this._options.shape, true);
        this._cursor.getColor().set(1.0f, 0.75f, 0.75f, 1.0f);
    }

    public void tick(float elapsed) {
        this.updateCursor();
    }

    public void composite() {
        if (this._cursorVisible) {
            this._cursor.composite();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this._cursorVisible) {
            float increment = event.isShiftDown() ? FINE_ROTATION_INCREMENT : 1.5707964f;
            this._angle = (float)(Math.round(this._angle / increment) + event.getWheelRotation()) * increment;
        }
    }

    protected void updateCursor() {
        this._cursorVisible = this.getMousePlaneIntersection(this._isect) && !this._editor.isSpecialDown();
        if (!this._cursorVisible) {
            return;
        }
        if (!this._editor.isShiftDown()) {
            this._isect.x = FloatMath.floor(this._isect.x) + 0.5f;
            this._isect.y = FloatMath.floor(this._isect.y) + 0.5f;
        }
        Transform3D transform = this._cursor.getTransform();
        transform.getTranslation().set(this._isect.x, this._isect.y, this._editor.getGrid().getZ());
        transform.getRotation().fromAngleAxis(this._angle, Vector3f.UNIT_Z);
        if (this._editor.isFirstButtonDown()) {
            this._transform.getTranslation().set(this._isect.x, this._isect.y);
            this._transform.setRotation(this._angle);
            this._shape = this._options.shape.getShape().transform(this._transform, this._shape);
            this._scene.getEntries(this._shape, (Predicate<? super TudeySceneModel.Entry>)Predicates.and((Predicate)this._options.filter, this._editor.getLayerPredicate()), this._entries);
            this._editor.removeEntries(this._entries);
            this._entries.clear();
        }
    }

    protected static class Options
    extends DeepObject
    implements Exportable {
        @Editable
        public ShapeConfig shape = new ShapeConfig.Rectangle();
        @Editable
        public EditorTool.Filter filter = new EditorTool.Filter();

        protected Options() {
        }
    }
}

