/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.threerings.math.Plane;
import com.threerings.math.Ray3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Grid;
import com.threerings.opengl.util.Tickable;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.tudey.util.TudeySceneMetrics;

public class EditorGrid
extends Grid
implements Tickable {
    protected int _elevation;
    protected Plane _plane = new Plane(Plane.XY_PLANE);
    protected Ray3D _target = new Ray3D();
    protected Vector3f _isect = new Vector3f();
    protected static final int LINE_COUNT = 65;

    public EditorGrid(SceneEditor editor) {
        super((GlContext)editor, 65, 1.0f);
    }

    public void setElevation(int elevation) {
        this._elevation = elevation;
        this._plane.constant = -this.getZ();
    }

    public int getElevation() {
        return this._elevation;
    }

    public float getZ() {
        return TudeySceneMetrics.getTileZ(this._elevation);
    }

    public Plane getPlane() {
        return this._plane;
    }

    public void tick(float elapsed) {
        this._ctx.getCompositor().getCamera().getCenterRay(this._target);
        this._plane.getIntersection(this._target, this._isect);
        int gx = (int)this._isect.x;
        int gy = (int)this._isect.y;
        this._transform.getTranslation().set(gx, gy, this.getZ());
    }
}

