/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.space;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.space.SpaceObject;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Space {
    protected boolean _disposed;
    protected Vector2f _result = new Vector2f();

    public void add(SpaceElement element) {
        this.addToSpatial(element);
        element.wasAdded(this);
    }

    public void remove(SpaceElement element) {
        if (this._disposed) {
            return;
        }
        element.willBeRemoved();
        this.removeFromSpatial(element);
    }

    public SpaceElement getIntersection(Ray2D ray, Vector2f location) {
        Predicate filter = Predicates.alwaysTrue();
        return this.getIntersection(ray, location, (Predicate<? super SpaceElement>)filter);
    }

    public abstract SpaceElement getIntersection(Ray2D var1, Vector2f var2, Predicate<? super SpaceElement> var3);

    public void getIntersecting(Shape shape, Collection<SpaceElement> results) {
        Predicate filter = Predicates.alwaysTrue();
        this.getIntersecting(shape, (Predicate<? super SpaceElement>)filter, results);
    }

    public abstract void getIntersecting(Shape var1, Predicate<? super SpaceElement> var2, Collection<SpaceElement> var3);

    public abstract void getElements(Rect var1, Collection<SpaceElement> var2);

    public void boundsWillChange(SpaceElement element) {
    }

    public void boundsDidChange(SpaceElement element) {
    }

    public void dispose() {
        this._disposed = true;
    }

    protected abstract void addToSpatial(SpaceElement var1);

    protected abstract void removeFromSpatial(SpaceElement var1);

    protected SpaceElement getIntersection(ArrayList<SpaceElement> elements, Ray2D ray, Vector2f location, Predicate<? super SpaceElement> filter) {
        SpaceElement closest = null;
        Vector2f origin = ray.getOrigin();
        int nn = elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SpaceElement element = elements.get(ii);
            if (!filter.apply((Object)element) || !element.getIntersection(ray, this._result) || closest != null && !(origin.distanceSquared(this._result) < origin.distanceSquared(location))) continue;
            closest = element;
            location.set(this._result);
        }
        return closest;
    }

    protected static void getIntersecting(ArrayList<SpaceElement> elements, Shape shape, Predicate<? super SpaceElement> filter, Collection<SpaceElement> results) {
        int nn = elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SpaceElement element = elements.get(ii);
            if (!filter.apply((Object)element) || !shape.intersects(element)) continue;
            results.add(element);
        }
    }

    protected static <T extends SpaceObject> void getIntersecting(ArrayList<T> objects, Rect bounds, Collection<T> results) {
        int nn = objects.size();
        for (int ii = 0; ii < nn; ++ii) {
            SpaceObject object = (SpaceObject)objects.get(ii);
            if (!object.getBounds().intersects(bounds)) continue;
            results.add(object);
        }
    }
}

