/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.space;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.Space;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.space.SpaceObject;
import com.threerings.tudey.util.Coord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashSpace
extends Space {
    protected float _granularity;
    protected int _levels;
    protected HashMap<Coord, Node<SpaceElement>> _elements = Maps.newHashMap();
    protected ArrayList<SpaceElement> _oversizedElements = new ArrayList();
    protected Rect _bounds = new Rect();
    protected Coord _minCoord = new Coord(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Coord _maxCoord = new Coord(Integer.MIN_VALUE, Integer.MIN_VALUE);
    protected int _visit;
    protected Coord _coord = new Coord();
    protected Rect _rect = new Rect();
    protected Vector2f _pt = new Vector2f();
    protected List<InternalNode> _internalNodePool = Lists.newArrayList();
    protected List<LeafNode> _leafNodePool = Lists.newArrayList();

    public HashSpace(float granularity, int levels) {
        this._granularity = granularity;
        this._levels = levels;
    }

    @Override
    public SpaceElement getIntersection(Ray2D ray, Vector2f location, Predicate<? super SpaceElement> filter) {
        SpaceElement closest = this.getIntersection(this._oversizedElements, ray, location, filter);
        if (!this._bounds.getIntersection(ray, this._pt)) {
            return closest;
        }
        ++this._visit;
        Vector2f origin = ray.getOrigin();
        Vector2f dir = ray.getDirection();
        int xdir = (int)Math.signum(dir.x);
        int ydir = (int)Math.signum(dir.y);
        float rgran = 1.0f / this._granularity;
        float px = this._pt.x * rgran;
        float py = this._pt.y * rgran;
        int lx = xdir < 0 ? FloatMath.iceil(px) : FloatMath.ifloor(px);
        int ly = ydir < 0 ? FloatMath.iceil(py) : FloatMath.ifloor(py);
        Vector2f result = new Vector2f();
        do {
            float t;
            SpaceElement element;
            this._coord.set(lx - (xdir < 0 ? 1 : 0), ly - (ydir < 0 ? 1 : 0));
            Node<SpaceElement> root = this._elements.get(this._coord);
            if (root != null && (element = root.getIntersection(ray, result, filter)) != null) {
                if (closest == null || origin.distanceSquared(result) < origin.distanceSquared(location)) {
                    closest = element;
                    location.set(result);
                }
                return closest;
            }
            float xt = xdir == 0 ? Float.MAX_VALUE : ((float)(lx + xdir) * this._granularity - origin.x) / dir.x;
            float yt = ydir == 0 ? Float.MAX_VALUE : ((float)(ly + ydir) * this._granularity - origin.y) / dir.y;
            float f = t = xt < yt ? xt : yt;
            if (xt == t) {
                lx += xdir;
            }
            if (yt != t) continue;
            ly += ydir;
        } while (this._coord.x >= this._minCoord.x && this._coord.x <= this._maxCoord.x && this._coord.y >= this._minCoord.y && this._coord.y <= this._maxCoord.y);
        return closest;
    }

    @Override
    public void getIntersecting(Shape shape, Predicate<? super SpaceElement> filter, Collection<SpaceElement> results) {
        HashSpace.getIntersecting(this._oversizedElements, shape, filter, results);
        shape.getBounds().intersect(this._bounds, this._rect);
        if (this._rect.isEmpty()) {
            return;
        }
        ++this._visit;
        Vector2f min = this._rect.getMinimumExtent();
        Vector2f max = this._rect.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                Node<SpaceElement> root = this._elements.get(this._coord.set(xx, yy));
                if (root == null) continue;
                root.get(shape, filter, results);
            }
        }
    }

    @Override
    public void getElements(Rect bounds, Collection<SpaceElement> results) {
        this.getIntersecting(this._elements, this._oversizedElements, bounds, results);
    }

    @Override
    public void boundsWillChange(SpaceElement element) {
        super.boundsWillChange(element);
        this.removeFromSpatial(element);
    }

    @Override
    public void boundsDidChange(SpaceElement element) {
        this.addToSpatial(element);
        super.boundsDidChange(element);
    }

    @Override
    protected void addToSpatial(SpaceElement element) {
        this.add(this._elements, this._oversizedElements, element);
    }

    @Override
    protected void removeFromSpatial(SpaceElement element) {
        this.remove(this._elements, this._oversizedElements, element);
    }

    protected <T extends SpaceObject> void add(HashMap<Coord, Node<T>> roots, ArrayList<T> oversized, T object) {
        Rect bounds = object.getBounds();
        if (this.areOversized(bounds)) {
            oversized.add(object);
            return;
        }
        int level = this.getLevel(bounds);
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                Node<T> root = roots.get(this._coord.set(xx, yy));
                if (root == null) {
                    root = this.createRoot(xx, yy);
                    roots.put(this._coord.clone(), root);
                    this.addBounds(this._coord, root);
                }
                root.add(object, level);
            }
        }
    }

    protected <T extends SpaceObject> void remove(HashMap<Coord, Node<T>> roots, ArrayList<T> oversized, T object) {
        Rect bounds = object.getBounds();
        if (this.areOversized(bounds)) {
            oversized.remove(object);
            return;
        }
        int level = this.getLevel(bounds);
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                Node<T> root = roots.get(this._coord.set(xx, yy));
                if (root == null) continue;
                root.remove(object, level);
                if (!root.isEmpty()) continue;
                roots.remove(this._coord);
                this.recomputeBounds();
            }
        }
    }

    protected boolean areOversized(Rect bounds) {
        return bounds.getLongestEdge() > this._granularity * 2.0f;
    }

    protected <T extends SpaceObject> void getIntersecting(HashMap<Coord, Node<T>> roots, ArrayList<T> oversized, Rect bounds, Collection<T> results) {
        HashSpace.getIntersecting(oversized, bounds, results);
        bounds.intersect(this._bounds, this._rect);
        if (this._rect.isEmpty()) {
            return;
        }
        ++this._visit;
        Vector2f min = this._rect.getMinimumExtent();
        Vector2f max = this._rect.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                Node<T> root = roots.get(this._coord.set(xx, yy));
                if (root == null) continue;
                root.get(bounds, results);
            }
        }
    }

    protected int getLevel(Rect bounds) {
        int level = FloatMath.round(FloatMath.log(bounds.getLongestEdge() / this._granularity) / FloatMath.log(0.5f));
        return Math.min(Math.max(level, 0), this._levels - 1);
    }

    protected <T extends SpaceObject> Node<T> createRoot(int x, int y) {
        Node<T> root = this.getFromNodePool(this._levels);
        Rect bounds = root.getBounds();
        bounds.getMinimumExtent().set((float)x * this._granularity, (float)y * this._granularity);
        bounds.getMaximumExtent().set((float)(x + 1) * this._granularity, (float)(y + 1) * this._granularity);
        return root;
    }

    protected void recomputeBounds() {
        this._bounds.setToEmpty();
        this._minCoord.set(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this._maxCoord.set(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.addBounds(this._elements);
    }

    protected <T extends SpaceObject> void addBounds(HashMap<Coord, Node<T>> roots) {
        for (Map.Entry<Coord, Node<T>> entry : roots.entrySet()) {
            this.addBounds(entry.getKey(), entry.getValue());
        }
    }

    protected <T extends SpaceObject> void addBounds(Coord coord, Node<T> node) {
        this._bounds.addLocal(node.getBounds());
        this._minCoord.set(Math.min(coord.x, this._minCoord.x), Math.min(coord.y, this._minCoord.y));
        this._maxCoord.set(Math.max(coord.x, this._maxCoord.x), Math.max(coord.y, this._maxCoord.y));
    }

    protected <T extends SpaceObject> Node<T> getFromNodePool(int levels) {
        if (levels > 1) {
            return this.getFromInternalNodePool(levels - 1);
        }
        return this.getFromLeafNodePool();
    }

    protected <T extends SpaceObject> InternalNode<T> getFromInternalNodePool(int levels) {
        int size = this._internalNodePool.size();
        if (size == 0) {
            return new InternalNode(levels);
        }
        InternalNode node = this._internalNodePool.remove(size - 1);
        node.reinit(levels);
        return node;
    }

    protected <T extends SpaceObject> LeafNode<T> getFromLeafNodePool() {
        int size = this._leafNodePool.size();
        if (size == 0) {
            return new LeafNode();
        }
        LeafNode node = this._leafNodePool.remove(size - 1);
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LeafNode<T extends SpaceObject>
    extends Node<T> {
        protected LeafNode() {
        }

        @Override
        public void returnToPool() {
            HashSpace.this._leafNodePool.add(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InternalNode<T extends SpaceObject>
    extends Node<T> {
        public int _levels;
        public Node<T>[] _children;

        public InternalNode(int levels) {
            this._children = new Node[4];
            this._levels = levels;
        }

        public void reinit(int levels) {
            this._levels = levels;
        }

        @Override
        public boolean isEmpty() {
            if (!super.isEmpty()) {
                return false;
            }
            for (Node<T> child : this._children) {
                if (child == null) continue;
                return false;
            }
            return true;
        }

        @Override
        public void add(T object, int level) {
            if (level == 0) {
                super.add(object, level);
                return;
            }
            --level;
            Rect bounds = object.getBounds();
            for (int ii = 0; ii < this._children.length; ++ii) {
                Node<T> child = this._children[ii];
                if (child == null) {
                    this.getChildBounds(ii, HashSpace.this._rect);
                    if (!HashSpace.this._rect.intersects(bounds)) continue;
                    child = HashSpace.this.getFromNodePool(this._levels);
                    this._children[ii] = child;
                    child.getBounds().set(HashSpace.this._rect);
                    child.add(object, level);
                    continue;
                }
                if (!child.getBounds().intersects(bounds)) continue;
                child.add(object, level);
            }
        }

        @Override
        public void remove(T object, int level) {
            if (level == 0) {
                super.remove(object, level);
                return;
            }
            --level;
            Rect bounds = object.getBounds();
            for (int ii = 0; ii < this._children.length; ++ii) {
                Node<T> child = this._children[ii];
                if (child == null || !child.getBounds().intersects(bounds)) continue;
                child.remove(object, level);
                if (!child.isEmpty()) continue;
                child.returnToPool();
                this._children[ii] = null;
            }
        }

        @Override
        public T getIntersection(Ray2D ray, Vector2f location, Predicate<? super T> filter) {
            T closest = super.getIntersection(ray, location, filter);
            Vector2f origin = ray.getOrigin();
            Vector2f result = new Vector2f();
            for (Node<? super T> node : this._children) {
                T object;
                if (node == null || !node.getBounds().intersects(ray) || (object = node.getIntersection(ray, result, filter)) == null || closest != null && !(origin.distanceSquared(result) < origin.distanceSquared(location))) continue;
                closest = object;
                location.set(result);
            }
            return closest;
        }

        @Override
        public void returnToPool() {
            HashSpace.this._internalNodePool.add(this);
        }

        @Override
        protected void getAll(Predicate<? super T> filter, Collection<T> results) {
            super.getAll(filter, results);
            for (Node<? super T> node : this._children) {
                if (node == null) continue;
                node.getAll(filter, results);
            }
        }

        @Override
        protected void getIntersecting(Shape shape, Predicate<? super T> filter, Collection<T> results) {
            super.getIntersecting(shape, filter, results);
            for (Node<? super T> node : this._children) {
                if (node == null) continue;
                node.get(shape, filter, results);
            }
        }

        @Override
        protected void getIntersecting(Rect bounds, Predicate<? super T> filter, Collection<T> results) {
            super.getIntersecting(bounds, filter, results);
            for (Node<? super T> node : this._children) {
                if (node == null) continue;
                node.get(bounds, filter, results);
            }
        }

        protected void getChildBounds(int idx, Rect rect) {
            Vector2f pmin = this._bounds.getMinimumExtent();
            Vector2f pmax = this._bounds.getMaximumExtent();
            Vector2f cmin = rect.getMinimumExtent();
            Vector2f cmax = rect.getMaximumExtent();
            float hsize = (pmax.x - pmin.x) * 0.5f;
            if ((idx & 2) == 0) {
                cmin.x = pmin.x;
                cmax.x = pmin.x + hsize;
            } else {
                cmin.x = pmin.x + hsize;
                cmax.x = pmax.x;
            }
            if ((idx & 1) == 0) {
                cmin.y = pmin.y;
                cmax.y = pmin.y + hsize;
            } else {
                cmin.y = pmin.y + hsize;
                cmax.y = pmax.y;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Node<T extends SpaceObject> {
        public Rect _bounds = new Rect();
        public ArrayList<T> _objects = new ArrayList(4);

        protected Node() {
        }

        public Rect getBounds() {
            return this._bounds;
        }

        public boolean isEmpty() {
            return this._objects.isEmpty();
        }

        public void add(T object, int level) {
            this._objects.add(object);
        }

        public void remove(T object, int level) {
            this._objects.remove(object);
        }

        public T getIntersection(Ray2D ray, Vector2f location, Predicate<? super T> filter) {
            SpaceObject closest = null;
            Vector2f origin = ray.getOrigin();
            int nn = this._objects.size();
            for (int ii = 0; ii < nn; ++ii) {
                SpaceObject object = (SpaceObject)this._objects.get(ii);
                if (!filter.apply((Object)object) || !object.updateLastVisit(HashSpace.this._visit) || !((SpaceElement)object).getIntersection(ray, HashSpace.this._result) || closest != null && !(origin.distanceSquared(HashSpace.this._result) < origin.distanceSquared(location))) continue;
                closest = object;
                location.set(HashSpace.this._result);
            }
            return (T)closest;
        }

        public void get(Shape shape, Collection<T> results) {
            this.get(shape, Predicates.alwaysTrue(), results);
        }

        public void get(Shape shape, Predicate<? super T> filter, Collection<T> results) {
            if (shape.getIntersectionType(this._bounds) != Shape.IntersectionType.NONE) {
                this.getIntersecting(shape, filter, results);
            }
        }

        public void get(Rect bounds, Collection<T> results) {
            this.get(bounds, Predicates.alwaysTrue(), results);
        }

        public void get(Rect bounds, Predicate<? super T> filter, Collection<T> results) {
            if (bounds.contains(this._bounds)) {
                this.getAll(filter, results);
            } else if (bounds.intersects(this._bounds)) {
                this.getIntersecting(bounds, filter, results);
            }
        }

        public abstract void returnToPool();

        protected void getAll(Predicate<? super T> filter, Collection<T> results) {
            int nn = this._objects.size();
            for (int ii = 0; ii < nn; ++ii) {
                SpaceObject object = (SpaceObject)this._objects.get(ii);
                if (!object.updateLastVisit(HashSpace.this._visit) || !filter.apply((Object)object)) continue;
                results.add(object);
            }
        }

        protected void getIntersecting(Shape shape, Predicate<? super T> filter, Collection<T> results) {
            int nn = this._objects.size();
            for (int ii = 0; ii < nn; ++ii) {
                SpaceObject object = (SpaceObject)this._objects.get(ii);
                if (!object.updateLastVisit(HashSpace.this._visit) || !filter.apply((Object)object) || !shape.intersects((SpaceElement)object)) continue;
                results.add(object);
            }
        }

        protected void getIntersecting(Rect bounds, Predicate<? super T> filter, Collection<T> results) {
            int nn = this._objects.size();
            for (int ii = 0; ii < nn; ++ii) {
                SpaceObject object = (SpaceObject)this._objects.get(ii);
                if (!object.updateLastVisit(HashSpace.this._visit) || !filter.apply((Object)object) || !object.getBounds().intersects(bounds)) continue;
                results.add(object);
            }
        }
    }
}

