/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;
import org.lwjgl.opengl.GL11;

public class Point
extends Shape {
    protected Vector2f _location = new Vector2f();

    public Point(Vector2f location) {
        this._location.set(location);
        this.updateBounds();
    }

    public Point(float x, float y) {
        this._location.set(x, y);
        this.updateBounds();
    }

    public Point() {
    }

    public Vector2f getLocation() {
        return this._location;
    }

    public void updateBounds() {
        this._bounds.getMinimumExtent().set(this._location);
        this._bounds.getMaximumExtent().set(this._location);
    }

    public Vector2f getCenter(Vector2f result) {
        return result.set(this._location);
    }

    public Shape transform(Transform2D transform, Shape result) {
        Point presult = result instanceof Point ? (Point)result : new Point();
        transform.transformPoint(this._location, presult._location);
        presult.updateBounds();
        return presult;
    }

    public Shape expand(float amount, Shape result) {
        Circle cresult = result instanceof Circle ? (Circle)result : new Circle();
        cresult.getCenter().set(this._location);
        cresult.radius = amount;
        cresult.updateBounds();
        return cresult;
    }

    public Shape sweep(Vector2f translation, Shape result) {
        Segment sresult = result instanceof Segment ? (Segment)result : new Segment();
        sresult.getStart().set(this._location);
        this._location.add(translation, sresult.getEnd());
        sresult.updateBounds();
        return sresult;
    }

    public Vector2f[] getPerimeterPath() {
        return new Vector2f[]{new Vector2f(this._location)};
    }

    public boolean getIntersection(Ray2D ray, Vector2f result) {
        boolean isect = ray.intersects(this._location);
        if (isect) {
            result.set(this._location);
        }
        return isect;
    }

    public void getNearestPoint(Vector2f point, Vector2f result) {
        result.set(this._location);
    }

    public Shape.IntersectionType getIntersectionType(Rect rect) {
        return rect.contains(this._location) ? Shape.IntersectionType.INTERSECTS : Shape.IntersectionType.NONE;
    }

    public boolean intersects(SpaceElement element) {
        return element.intersects(this);
    }

    public boolean intersects(Shape shape) {
        return shape.intersects(this);
    }

    public boolean intersects(Point point) {
        return point.getLocation().equals(this._location);
    }

    public boolean intersects(Segment segment) {
        return segment.intersects(this);
    }

    public boolean intersects(Circle circle) {
        return circle.intersects(this);
    }

    public boolean intersects(Capsule capsule) {
        return capsule.intersects(this);
    }

    public boolean intersects(Polygon polygon) {
        return polygon.intersects(this);
    }

    public boolean intersects(Compound compound) {
        return compound.intersects(this);
    }

    public Vector2f getPenetration(Shape shape, Vector2f result) {
        return shape.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Point point, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    public Vector2f getPenetration(Segment segment, Vector2f result) {
        return segment.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Circle circle, Vector2f result) {
        return circle.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Capsule capsule, Vector2f result) {
        return capsule.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Polygon polygon, Vector2f result) {
        return polygon.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Compound compound, Vector2f result) {
        return compound.getPenetration(this, result).negateLocal();
    }

    public void draw(boolean outline) {
        GL11.glBegin((int)0);
        GL11.glVertex2f((float)this._location.x, (float)this._location.y);
        GL11.glEnd();
    }

    public ShapeConfig createConfig() {
        ShapeConfig.Point point = new ShapeConfig.Point();
        ShapeConfig.TransformedShape transformed = new ShapeConfig.TransformedShape();
        transformed.shape = point;
        transformed.transform.set(this._location, 0.0f);
        ShapeConfig.Compound compound = new ShapeConfig.Compound();
        compound.shapes = new ShapeConfig.TransformedShape[]{transformed};
        return compound;
    }
}

