/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.samskivert.util.StringUtil;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;

public class Compound
extends Shape {
    protected Shape[] _shapes;

    public Compound(Shape ... shapes) {
        this._shapes = shapes;
        this.updateBounds();
    }

    public Compound(int scount) {
        this._shapes = new Shape[scount];
    }

    public int getShapeCount() {
        return this._shapes.length;
    }

    public Shape getShape(int idx) {
        return this._shapes[idx];
    }

    public Shape[] getShapes() {
        return this._shapes;
    }

    public void updateBounds() {
        this._bounds.setToEmpty();
        for (Shape shape : this._shapes) {
            shape.updateBounds();
            this._bounds.addLocal(shape.getBounds());
        }
    }

    public Vector2f getCenter(Vector2f result) {
        result.set(0.0f, 0.0f);
        Vector2f pt = new Vector2f();
        for (Shape shape : this._shapes) {
            result.addLocal(shape.getCenter(pt));
        }
        return result.multLocal(1.0f / (float)this._shapes.length);
    }

    public Shape transform(Transform2D transform, Shape result) {
        Compound cresult;
        Compound compound = cresult = result instanceof Compound ? (Compound)result : new Compound(this._shapes.length);
        if (cresult.getShapeCount() != this._shapes.length) {
            cresult._shapes = new Shape[this._shapes.length];
        }
        for (int ii = 0; ii < this._shapes.length; ++ii) {
            cresult._shapes[ii] = this._shapes[ii].transform(transform, cresult._shapes[ii]);
        }
        cresult.updateBounds();
        return cresult;
    }

    public Shape expand(float amount, Shape result) {
        Compound cresult;
        Compound compound = cresult = result instanceof Compound ? (Compound)result : new Compound(this._shapes.length);
        if (cresult.getShapeCount() != this._shapes.length) {
            cresult._shapes = new Shape[this._shapes.length];
        }
        for (int ii = 0; ii < this._shapes.length; ++ii) {
            cresult._shapes[ii] = this._shapes[ii].expand(amount, cresult._shapes[ii]);
        }
        cresult.updateBounds();
        return cresult;
    }

    public Shape sweep(Vector2f translation, Shape result) {
        Compound cresult;
        Compound compound = cresult = result instanceof Compound ? (Compound)result : new Compound(this._shapes.length);
        if (cresult.getShapeCount() != this._shapes.length) {
            cresult._shapes = new Shape[this._shapes.length];
        }
        for (int ii = 0; ii < this._shapes.length; ++ii) {
            cresult._shapes[ii] = this._shapes[ii].sweep(translation, cresult._shapes[ii]);
        }
        cresult.updateBounds();
        return cresult;
    }

    public boolean getIntersection(Ray2D ray, Vector2f result) {
        if (!this._bounds.intersects(ray)) {
            return false;
        }
        Vector2f closest = result;
        for (Shape shape : this._shapes) {
            if (!shape.getIntersection(ray, result)) continue;
            result = Compound.updateClosest(ray.getOrigin(), result, closest);
        }
        return result != closest;
    }

    public void getNearestPoint(Vector2f point, Vector2f result) {
        Vector2f currentResult = new Vector2f();
        float minDist = Float.MAX_VALUE;
        for (Shape shape : this._shapes) {
            shape.getNearestPoint(point, currentResult);
            float dist = point.distanceSquared(currentResult);
            if (!(dist < minDist)) continue;
            minDist = dist;
            result.set(currentResult);
            if (!(Math.abs(minDist) < 1.0E-6f)) continue;
            return;
        }
    }

    public Shape.IntersectionType getIntersectionType(Rect rect) {
        if (!rect.intersects(this._bounds)) {
            return Shape.IntersectionType.NONE;
        }
        Shape.IntersectionType type = Shape.IntersectionType.NONE;
        for (Shape shape : this._shapes) {
            switch (shape.getIntersectionType(rect)) {
                case CONTAINS: {
                    return Shape.IntersectionType.CONTAINS;
                }
                case INTERSECTS: {
                    type = Shape.IntersectionType.INTERSECTS;
                }
            }
        }
        return type;
    }

    public boolean intersects(SpaceElement element) {
        return element.intersects(this);
    }

    public boolean intersects(Shape shape) {
        return shape.intersects(this);
    }

    public boolean intersects(Point point) {
        if (!point.getBounds().intersects(this._bounds)) {
            return false;
        }
        for (Shape shape : this._shapes) {
            if (!shape.intersects(point)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Segment segment) {
        if (!segment.getBounds().intersects(this._bounds)) {
            return false;
        }
        for (Shape shape : this._shapes) {
            if (!shape.intersects(segment)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Circle circle) {
        if (!circle.getBounds().intersects(this._bounds)) {
            return false;
        }
        for (Shape shape : this._shapes) {
            if (!shape.intersects(circle)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Capsule capsule) {
        if (!capsule.getBounds().intersects(this._bounds)) {
            return false;
        }
        for (Shape shape : this._shapes) {
            if (!shape.intersects(capsule)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Polygon polygon) {
        if (!polygon.getBounds().intersects(this._bounds)) {
            return false;
        }
        for (Shape shape : this._shapes) {
            if (!shape.intersects(polygon)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Compound compound) {
        if (!compound.getBounds().intersects(this._bounds)) {
            return false;
        }
        for (Shape shape : this._shapes) {
            if (!compound.intersects(shape)) continue;
            return true;
        }
        return false;
    }

    public Vector2f getPenetration(Shape shape, Vector2f result) {
        return shape.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Point point, Vector2f result) {
        return this.getSimplePenetration(point, result);
    }

    public Vector2f getPenetration(Segment segment, Vector2f result) {
        return this.getSimplePenetration(segment, result);
    }

    public Vector2f getPenetration(Circle circle, Vector2f result) {
        return this.getSimplePenetration(circle, result);
    }

    public Vector2f getPenetration(Capsule capsule, Vector2f result) {
        return this.getSimplePenetration(capsule, result);
    }

    public Vector2f getPenetration(Polygon polygon, Vector2f result) {
        return this.getSimplePenetration(polygon, result);
    }

    public Vector2f getPenetration(Compound compound, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    public void draw(boolean outline) {
        for (Shape shape : this._shapes) {
            shape.draw(outline);
        }
    }

    public ShapeConfig createConfig() {
        ShapeConfig.Compound compound = new ShapeConfig.Compound();
        compound.shapes = new ShapeConfig.TransformedShape[this._shapes.length];
        for (int ii = 0; ii < this._shapes.length; ++ii) {
            ShapeConfig.TransformedShape tshape = compound.shapes[ii] = new ShapeConfig.TransformedShape();
            tshape.shape = this._shapes[ii].createConfig();
        }
        return compound;
    }

    public String toString() {
        return "Comp:(" + StringUtil.join((Object[])this._shapes) + ")";
    }

    protected Vector2f getSimplePenetration(Shape shape, Vector2f result) {
        result.set(Vector2f.ZERO);
        Vector2f oresult = new Vector2f();
        for (Shape cshape : this._shapes) {
            if (!cshape.intersects(shape)) continue;
            cshape.getPenetration(shape, oresult);
            if (!(oresult.lengthSquared() > result.lengthSquared())) continue;
            result.set(oresult);
        }
        return result;
    }
}

