/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.math.FloatMath;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;
import org.lwjgl.opengl.GL11;

public class Circle
extends Shape {
    public float radius;
    protected Vector2f _center = new Vector2f();

    public Circle(Vector2f center, float radius) {
        this._center.set(center);
        this.radius = radius;
        this.updateBounds();
    }

    public Circle() {
    }

    public Vector2f getCenter() {
        return this._center;
    }

    public boolean contains(Vector2f pt) {
        return this._center.distanceSquared(pt) <= this.radius * this.radius;
    }

    public void updateBounds() {
        this._bounds.getMinimumExtent().set(this._center);
        this._bounds.getMaximumExtent().set(this._center);
        this._bounds.expandLocal(this.radius, this.radius);
    }

    public Vector2f getCenter(Vector2f result) {
        return result.set(this._center);
    }

    public Shape transform(Transform2D transform, Shape result) {
        Circle cresult = result instanceof Circle ? (Circle)result : new Circle();
        transform.transformPoint(this._center, cresult._center);
        cresult.radius = this.radius * transform.approximateUniformScale();
        cresult.updateBounds();
        return cresult;
    }

    public Shape expand(float amount, Shape result) {
        Circle cresult = result instanceof Circle ? (Circle)result : new Circle();
        cresult.getCenter().set(this._center);
        cresult.radius = this.radius + amount;
        cresult.updateBounds();
        return cresult;
    }

    public Shape sweep(Vector2f translation, Shape result) {
        Capsule cresult = result instanceof Capsule ? (Capsule)result : new Capsule();
        cresult.getStart().set(this._center);
        this._center.add(translation, cresult.getEnd());
        cresult.radius = this.radius;
        cresult.updateBounds();
        return cresult;
    }

    public boolean getIntersection(Ray2D ray, Vector2f result) {
        return ray.getIntersection(this._center, this.radius, result);
    }

    public void getNearestPoint(Vector2f point, Vector2f result) {
        this.getIntersection(new Ray2D(point, this._center.subtract(point).normalize()), result);
    }

    public Shape.IntersectionType getIntersectionType(Rect rect) {
        Vector2f min = rect.getMinimumExtent();
        Vector2f max = rect.getMaximumExtent();
        float r2 = this.radius * this.radius;
        int ccount = (this.contains(min.x, min.y, r2) ? 1 : 0) + (this.contains(max.x, min.y, r2) ? 1 : 0) + (this.contains(max.x, max.y, r2) ? 1 : 0) + (this.contains(min.x, max.y, r2) ? 1 : 0);
        if (ccount > 0) {
            return ccount == 4 ? Shape.IntersectionType.CONTAINS : Shape.IntersectionType.INTERSECTS;
        }
        if (this._center.x < min.x) {
            return this._center.y >= min.y && this._center.y <= max.y && min.x - this._center.x <= this.radius ? Shape.IntersectionType.INTERSECTS : Shape.IntersectionType.NONE;
        }
        if (this._center.x > max.x) {
            return this._center.y >= min.y && this._center.y <= max.y && this._center.x - max.x <= this.radius ? Shape.IntersectionType.INTERSECTS : Shape.IntersectionType.NONE;
        }
        if (this._center.y < min.y) {
            return min.y - this._center.y <= this.radius ? Shape.IntersectionType.INTERSECTS : Shape.IntersectionType.NONE;
        }
        if (this._center.y > max.y) {
            return this._center.y - max.y <= this.radius ? Shape.IntersectionType.INTERSECTS : Shape.IntersectionType.NONE;
        }
        return Shape.IntersectionType.INTERSECTS;
    }

    public boolean intersects(SpaceElement element) {
        return element.intersects(this);
    }

    public boolean intersects(Shape shape) {
        return shape.intersects(this);
    }

    public boolean intersects(Point point) {
        return this.contains(point.getLocation());
    }

    public boolean intersects(Segment segment) {
        return Circle.intersects(this._center, this.radius, segment.getStart(), segment.getEnd());
    }

    public boolean intersects(Circle circle) {
        return circle.getCenter().distance(this._center) <= circle.radius + this.radius;
    }

    public boolean intersects(Capsule capsule) {
        return capsule.intersects(this);
    }

    public boolean intersects(Polygon polygon) {
        return polygon.intersects(this);
    }

    public boolean intersects(Compound compound) {
        return compound.intersects(this);
    }

    public Vector2f getPenetration(Shape shape, Vector2f result) {
        return shape.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Point point, Vector2f result) {
        Vector2f location = point.getLocation();
        float dist = location.distance(this._center);
        return dist == 0.0f ? result.set(Vector2f.ZERO) : location.subtract(this._center, result).multLocal(this.radius / dist - 1.0f);
    }

    public Vector2f getPenetration(Segment segment, Vector2f result) {
        return segment.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Circle circle, Vector2f result) {
        Vector2f ocenter = circle.getCenter();
        float dist = ocenter.distance(this._center);
        return dist == 0.0f ? result.set(Vector2f.ZERO) : ocenter.subtract(this._center, result).multLocal((this.radius + circle.radius) / dist - 1.0f);
    }

    public Vector2f getPenetration(Capsule capsule, Vector2f result) {
        return capsule.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Polygon polygon, Vector2f result) {
        return polygon.getPenetration(this, result).negateLocal();
    }

    public Vector2f getPenetration(Compound compound, Vector2f result) {
        return compound.getPenetration(this, result).negateLocal();
    }

    public void draw(boolean outline) {
        GL11.glBegin((int)(outline ? 2 : 9));
        for (int ii = 0; ii < 16; ++ii) {
            float angle = (float)ii * 0.3926991f;
            GL11.glVertex2f((float)(this._center.x + FloatMath.cos(angle) * this.radius), (float)(this._center.y + FloatMath.sin(angle) * this.radius));
        }
        GL11.glEnd();
    }

    public ShapeConfig createConfig() {
        ShapeConfig.Circle circle = new ShapeConfig.Circle();
        circle.radius = this.radius;
        ShapeConfig.TransformedShape transformed = new ShapeConfig.TransformedShape();
        transformed.shape = circle;
        transformed.transform.set(this._center, 0.0f);
        ShapeConfig.Compound compound = new ShapeConfig.Compound();
        compound.shapes = new ShapeConfig.TransformedShape[]{transformed};
        return compound;
    }

    public String toString() {
        return "[center=" + this._center + ", radius=" + this.radius + ", bounds=" + this._bounds + "]";
    }

    protected boolean contains(float x, float y, float r2) {
        float dx = x - this._center.x;
        float dy = y - this._center.y;
        return dx * dx + dy * dy <= r2;
    }
}

