/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.config.ConfigReference;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.BehaviorConfig;
import com.threerings.tudey.data.actor.Agent;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.server.logic.ActiveLogic;
import com.threerings.tudey.server.logic.BehaviorLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.util.ActiveAdvancer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentLogic
extends ActiveLogic {
    protected BehaviorLogic _behavior;
    protected float _targetRotation;
    protected float _turnRate;
    protected int _timestamp;

    public boolean canMove() {
        return ((ActiveAdvancer)this._advancer).canMove();
    }

    public boolean canRotate() {
        return ((ActiveAdvancer)this._advancer).canRotate();
    }

    public boolean canThink() {
        return this._behavior != null;
    }

    public Logic getBehaviorTarget() {
        return this._behavior == null ? null : this._behavior.getCurrentTarget();
    }

    public void face(Logic logic) {
        this.face(logic, false);
    }

    public void face(Logic logic, boolean force) {
        float rotation = this._actor.getTranslation().direction(logic.getTranslation());
        if (force && this.canRotate()) {
            this._actor.setRotation(rotation);
            this.clearTargetRotation();
        } else {
            this.setTargetRotation(rotation);
        }
    }

    public void setTargetRotation(float rotation) {
        this._targetRotation = rotation;
        if (this._targetRotation == this._actor.getRotation()) {
            this.reachedTargetRotation();
        }
    }

    public float getTargetRotation() {
        return this._targetRotation;
    }

    public void clearTargetRotation() {
        this._targetRotation = this._actor.getRotation();
        ((Agent)this._actor).setTurnDirection(0);
    }

    public void setTurnRate(float rate) {
        if (rate > 0.0f) {
            this._turnRate = rate;
        } else {
            this.clearTurnRate();
        }
    }

    public void clearTurnRate() {
        this._turnRate = ((ActorConfig.Agent)this._config).turnRate;
    }

    public void setSpeed(float speed) {
        ((Agent)this._actor).setSpeed(speed);
    }

    public void clearSpeed() {
        ((Agent)this._actor).setSpeed(((ActorConfig.Agent)this._config).speed);
    }

    public void startMoving() {
        if (this.canMove()) {
            ((Mobile)this._actor).setDirection(this._actor.getRotation());
            this._actor.set(2);
        }
    }

    public void stopMoving() {
        this._actor.clear(2);
    }

    public BehaviorLogic createBehavior(ConfigReference<BehaviorConfig> ref) {
        BehaviorLogic logic;
        BehaviorConfig.Original original;
        BehaviorConfig config = this._scenemgr.getConfigManager().getConfig(BehaviorConfig.class, ref);
        BehaviorConfig.Original original2 = original = config == null ? null : config.getOriginal(this._scenemgr.getConfigManager());
        if (original == null) {
            original = new BehaviorConfig.Original();
        }
        if ((logic = (BehaviorLogic)this._scenemgr.createLogic(original.getLogicClassName())) == null) {
            return null;
        }
        logic.init(this._scenemgr, original, this);
        return logic;
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        AgentLogic asource = (AgentLogic)source;
        this._targetRotation = asource._targetRotation;
        this._turnRate = asource._turnRate;
        this._timestamp = asource._timestamp;
        this._behavior.transfer(asource._behavior, refs);
    }

    @Override
    public boolean tick(int timestamp) {
        super.tick(timestamp);
        if (this._behavior != null) {
            this._behavior.tick(timestamp);
        }
        float elapsed = (float)(timestamp - this._timestamp) / 1000.0f;
        this._timestamp = timestamp;
        float rotation = this._actor.getRotation();
        if (rotation != this._targetRotation && this.canRotate()) {
            float diff = FloatMath.getAngularDifference(this._targetRotation, rotation);
            float angle = elapsed * this._turnRate;
            if (Math.abs(diff) - angle < 1.0E-6f) {
                this._actor.setRotation(this._targetRotation);
                this.reachedTargetRotation();
            } else {
                float dir = Math.signum(diff);
                ((Agent)this._actor).setTurnDirection((int)dir);
                this._actor.setRotation(FloatMath.normalizeAngle(rotation + angle * dir));
            }
        }
        return true;
    }

    @Override
    protected void wasDestroyed() {
        super.wasDestroyed();
        this._behavior.shutdown();
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._targetRotation = this._actor.getRotation();
        this._timestamp = this._actor.getCreated();
        this._behavior = this.createBehavior(((ActorConfig.Agent)this._config).behavior);
        this._behavior.startup();
        this.clearTurnRate();
        this.clearSpeed();
    }

    @Override
    protected void penetratedEnvironment(Vector2f penetration) {
        this._behavior.penetratedEnvironment(penetration);
    }

    protected void reachedTargetRotation() {
        ((Agent)this._actor).setTurnDirection(0);
        this._behavior.reachedTargetRotation();
    }
}

