/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.samskivert.util.ObserverList;
import com.threerings.config.ConfigReference;
import com.threerings.crowd.data.BodyObject;
import com.threerings.math.FloatMath;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.HasActor;
import com.threerings.tudey.dobj.ActorDelta;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.HandlerLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.ShapeElement;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorLogic
extends Logic
implements HasActor {
    protected ActorConfig.Original _config;
    protected EntityKey.Actor _entityKey;
    protected Actor _actor;
    protected Actor _snapshot;
    protected Actor _previousSnapshot;
    protected ActorDelta _snapshotDelta;
    protected int _snaptime;
    protected ShapeElement _shape;
    protected HandlerLogic[] _handlers;
    protected ObserverList<Logic.ShapeObserver> _shapeObservers = ObserverList.newFastUnsafe();
    protected ObserverList<CollisionFlagObserver> _collisionFlagObservers = ObserverList.newFastUnsafe();
    protected int _collisionFlags;
    protected Logic _source;
    protected Logic _activator;
    protected boolean _destroyed;
    protected ObserverList.ObserverOp<Logic.ShapeObserver> _shapeWillChangeOp = new ObserverList.ObserverOp<Logic.ShapeObserver>(){

        public boolean apply(Logic.ShapeObserver observer) {
            observer.shapeWillChange(ActorLogic.this);
            return true;
        }
    };
    protected ObserverList.ObserverOp<Logic.ShapeObserver> _shapeDidChangeOp = new ObserverList.ObserverOp<Logic.ShapeObserver>(){

        public boolean apply(Logic.ShapeObserver observer) {
            observer.shapeDidChange(ActorLogic.this);
            return true;
        }
    };
    protected static final int MAX_ADJUSTMENT_DISTANCE = 4;
    protected static final float MAX_ADJUSTMENT_PATH_LENGTH = 8.0f;

    public void init(TudeySceneManager scenemgr, ConfigReference<ActorConfig> ref, ActorConfig.Original config, int id, int timestamp, Vector2f translation, float rotation, Actor actor) {
        super.init(scenemgr);
        this._config = config;
        this._entityKey = new EntityKey.Actor(id);
        if (actor == null) {
            this._actor = this.createActor(ref, id, timestamp, translation, rotation);
            this._actor.init(scenemgr.getConfigManager());
        } else {
            this._actor = (Actor)actor.clone();
        }
        this._shape = new ShapeElement(config.shape);
        this._shape.setUserObject(this);
        this.updateShape();
        this.updateCollisionFlags();
        if (config.spawnMask != 0 && scenemgr.collides(config.spawnMask, this.getShape(), timestamp) && actor == null) {
            this.adjustSpawnPoint();
        }
        this._scenemgr.getActorSpace().add(this._shape);
        ArrayList<HandlerLogic> handlers = new ArrayList<HandlerLogic>();
        for (HandlerConfig hconfig : config.handlers) {
            HandlerLogic handler = this.createHandler(hconfig, this);
            if (handler == null) continue;
            handlers.add(handler);
        }
        this._handlers = handlers.toArray(new HandlerLogic[handlers.size()]);
        this.didInit();
        if (actor == null) {
            for (HandlerLogic handler : this._handlers) {
                handler.startup(timestamp);
            }
        }
        this._previousSnapshot = this._snapshot = (Actor)this._actor.clone();
    }

    public boolean isStatic() {
        return this._config.isStatic;
    }

    public void setSource(Logic source) {
        this._source = source;
    }

    public Logic getSource() {
        return this._source;
    }

    public void setActivator(Logic activator) {
        this._activator = activator;
    }

    public Logic getActivator() {
        return this._activator;
    }

    public int getCollisionFlags() {
        return this._collisionFlags;
    }

    public void addCollisionFlagObserver(CollisionFlagObserver observer) {
        this._collisionFlagObservers.add((Object)observer);
    }

    public void removeCollisionFlagObserver(CollisionFlagObserver observer) {
        this._collisionFlagObservers.remove((Object)observer);
    }

    public void bodyWillEnter(BodyObject body) {
    }

    public void bodyWillLeave(BodyObject body) {
        this.destroy(this._scenemgr.getNextTimestamp(), this);
    }

    public Actor getSnapshot() {
        this.updateSnapshot();
        return this._snapshot;
    }

    public Actor getPreviousSnapshot() {
        this.updateSnapshot();
        return this._previousSnapshot;
    }

    public ActorDelta getSnapshotDelta() {
        this.updateSnapshot();
        return this._snapshotDelta;
    }

    public ShapeElement getShapeElement() {
        return this._shape;
    }

    public boolean isDestroyed() {
        return this._scenemgr.getTimestamp() >= this._actor.getDestroyed();
    }

    public boolean isRemoved() {
        return this._shape.getSpace() == null;
    }

    public final void warp(float x, float y, float rotation) {
        this.warp(x, y, rotation, x, y);
    }

    public final void warp(float x, float y, float rotation, float tx, float ty) {
        this.warp(x, y, rotation, tx, ty, true);
    }

    public final void warp(float x, float y, float rotation, float tx, float ty, boolean adjust) {
        this.warp(x, y, rotation, tx, ty, adjust, 0);
    }

    public final void warp(float x, float y, float rotation, float tx, float ty, boolean adjust, int warpPath) {
        this._actor.set(1);
        float oldX = this._actor.getTranslation().x;
        float oldY = this._actor.getTranslation().y;
        float oldR = this._actor.getRotation();
        if (tx != x || ty != y) {
            rotation = FloatMath.atan2(ty - y, tx - x);
        }
        this.move(x, y, rotation);
        if (adjust && this._config.spawnMask != 0) {
            boolean canPath;
            this._scenemgr.getActorSpace().remove(this._shape);
            boolean bl = warpPath > 0 ? this._scenemgr.getPathfinder().getPath(this, warpPath, oldX, oldY, false, false) != null : (canPath = this._scenemgr.getPathfinder().getPath(this, 8.0f, tx, ty, false, false) != null);
            if (!canPath || this._scenemgr.collides(this._config.spawnMask, this.getShape(), this._scenemgr.getTimestamp())) {
                if (canPath) {
                    this.adjustSpawnPoint(x, y);
                } else {
                    this.adjustSpawnPoint(tx, ty);
                }
                boolean bl2 = warpPath > 0 ? this._scenemgr.getPathfinder().getPath(this, warpPath, oldX, oldY, false, false) != null : (canPath = this._scenemgr.getPathfinder().getPath(this, 8.0f, tx, ty, false, false) != null);
                if (!canPath) {
                    this.move(oldX, oldY, oldR);
                } else if (tx != x || ty != y) {
                    Vector2f trans = this._actor.getTranslation();
                    this._actor.setRotation(FloatMath.atan2(ty - trans.y, tx - trans.x));
                    this.updateShape();
                }
            }
            this._scenemgr.getActorSpace().add(this._shape);
        }
        this._scenemgr.addTickParticipant(new TudeySceneManager.TickParticipant(){

            public boolean tick(int timestamp) {
                ActorLogic.this._actor.clear(1);
                ActorLogic.this.wasUpdated();
                return false;
            }
        }, true);
    }

    public void move(float x, float y, float rotation) {
        this._actor.getTranslation().set(x, y);
        this._actor.setRotation(rotation);
        this.updateShape();
        this.wasUpdated();
    }

    public void destroy(int timestamp, Logic activator) {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        this._actor.setDestroyed(timestamp);
        this.wasUpdated();
        this.removeOnNextTick();
        for (HandlerLogic handler : this._handlers) {
            handler.shutdown(timestamp, activator);
        }
        this.wasDestroyed();
    }

    public void remove() {
        this._scenemgr.getActorSpace().remove(this._shape);
        this._scenemgr.removeActorLogic(this._actor.getId());
        for (HandlerLogic handler : this._handlers) {
            handler.removed();
        }
        this.wasRemoved();
    }

    @Override
    public Actor getActor() {
        return this._actor;
    }

    @Override
    public String[] getTags() {
        return this._config.tags.getTags();
    }

    @Override
    public boolean isDefaultEntrance() {
        return this._config.defaultEntrance;
    }

    @Override
    public boolean isActive() {
        return !this.isDestroyed();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._entityKey;
    }

    @Override
    public Vector2f getTranslation() {
        return this._actor.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._actor.getRotation();
    }

    @Override
    public Shape getShape() {
        return this._shape.getWorldShape();
    }

    @Override
    public void addShapeObserver(Logic.ShapeObserver observer) {
        this._shapeObservers.add((Object)observer);
    }

    @Override
    public void removeShapeObserver(Logic.ShapeObserver observer) {
        this._shapeObservers.remove((Object)observer);
    }

    @Override
    public ConfigReference<ModelConfig> getModel() {
        return this._config.sprite.model;
    }

    @Override
    public void signal(int timestamp, Logic source, String name) {
        if (this.isDestroyed() || this._handlers == null) {
            return;
        }
        for (HandlerLogic handler : this._handlers) {
            handler.signal(timestamp, source, name);
        }
    }

    @Override
    public void setVariable(int timestamp, Logic source, String name, Object value) {
        super.setVariable(timestamp, source, name, value);
        if (this._handlers != null) {
            for (HandlerLogic handler : this._handlers) {
                handler.variableChanged(timestamp, source, name);
            }
        }
    }

    @Override
    public void request(int timestamp, PawnLogic source, String name) {
        for (HandlerLogic handler : this._handlers) {
            handler.request(timestamp, source, name);
        }
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        ActorLogic sactor = (ActorLogic)source;
        HandlerLogic[] shandlers = sactor._handlers;
        for (int ii = 0; ii < this._handlers.length; ++ii) {
            this._handlers[ii].transfer(shandlers[ii], refs);
        }
        this._source = (Logic)refs.get(sactor._source);
        this._activator = (Logic)refs.get(sactor._activator);
        this._destroyed = sactor._destroyed;
        if (this._destroyed) {
            this.removeOnNextTick();
        }
    }

    protected void removeOnNextTick() {
        this._scenemgr.addTickParticipant(new TudeySceneManager.TickParticipant(){

            public boolean tick(int timestamp) {
                ActorLogic.this.remove();
                return false;
            }
        });
    }

    protected Actor createActor(ConfigReference<ActorConfig> ref, int id, int timestamp, Vector2f translation, float rotation) {
        return this._config.createActor(ref, id, timestamp, translation, rotation);
    }

    protected void adjustSpawnPoint() {
        boolean warp = this._actor.isSet(1);
        this._actor.set(1);
        Vector2f translation = this._actor.getTranslation();
        this.adjustSpawnPoint(translation.x, translation.y);
        if (!warp) {
            this._actor.clear(1);
        }
    }

    protected void adjustSpawnPoint(float tx, float ty) {
        Rect bounds = this._shape.getBounds();
        float width = bounds.getWidth() + 0.01f;
        float height = bounds.getHeight() + 0.01f;
        Vector2f translation = this._actor.getTranslation();
        float ox = translation.x;
        float oy = translation.y;
        for (int dist = 1; dist <= 4; ++dist) {
            int yy;
            int yy2;
            float bottom = oy - (float)dist * height;
            for (int xx = -dist; xx <= dist; ++xx) {
                if (!this.testSpawnPoint(tx, ty, ox + (float)xx * width, bottom)) continue;
                return;
            }
            float right = ox + (float)dist * width;
            int yymax = -yy2;
            for (yy2 = 1 - dist; yy2 <= yymax; ++yy2) {
                if (!this.testSpawnPoint(tx, ty, right, oy + (float)yy2 * height)) continue;
                return;
            }
            float top = oy + (float)dist * height;
            for (int xx = dist; xx >= -dist; --xx) {
                if (!this.testSpawnPoint(tx, ty, ox + (float)xx * width, top)) continue;
                return;
            }
            float left = ox - (float)dist * width;
            int yymin = -yy;
            for (yy = dist - 1; yy >= yymin; --yy) {
                if (!this.testSpawnPoint(tx, ty, left, oy + (float)yy * height)) continue;
                return;
            }
        }
        this._actor.setTranslation(ox, oy);
        this.updateShape();
    }

    protected boolean testSpawnPoint(float ox, float oy, float nx, float ny) {
        this._actor.setTranslation(nx, ny);
        this.updateShape();
        if (this._scenemgr.collides(this._config.spawnMask, this.getShape(), this._actor.getCreated())) {
            return false;
        }
        return this._scenemgr.getPathfinder().getPath(this, 8.0f, ox, oy, false, false) != null;
    }

    protected void updateShape() {
        this._shapeObservers.apply(this._shapeWillChangeOp);
        this._shape.getTransform().set(this._actor.getTranslation(), this._config.rotateShape ? this._actor.getRotation() : 0.0f, 1.0f);
        this._shape.updateBounds();
        this._shapeObservers.apply(this._shapeDidChangeOp);
    }

    protected void updateCollisionFlags() {
        int nflags = this._actor.getCollisionFlags();
        if (this._collisionFlags == nflags) {
            return;
        }
        final int oflags = this._collisionFlags;
        this._collisionFlags = nflags;
        this._collisionFlagObservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<CollisionFlagObserver>(){

            public boolean apply(CollisionFlagObserver observer) {
                observer.collisionFlagsChanged(ActorLogic.this, oflags);
                return true;
            }
        });
    }

    protected void updateSnapshot() {
        int timestamp = this._scenemgr.getTimestamp();
        if (timestamp > this._snaptime) {
            this._previousSnapshot = this._snapshot;
            this._snapshotDelta = null;
            if (this._actor.isDirty()) {
                this._snapshotDelta = new ActorDelta(this._snapshot, this._actor);
                if (this._snapshotDelta.isEmpty()) {
                    this._snapshotDelta = null;
                } else {
                    this._snapshot = (Actor)this._actor.clone();
                }
                this._actor.setDirty(false);
            }
            this._snaptime = timestamp;
        }
    }

    protected void didInit() {
    }

    protected void wasRemoved() {
    }

    protected void wasDestroyed() {
    }

    protected void set(int flag, boolean value) {
        this._actor.set(flag, value);
        this.wasUpdated();
    }

    protected void wasUpdated() {
        if (this.isStatic() && !this.isRemoved()) {
            this._scenemgr.staticActorUpdated(this);
        }
    }

    public static interface CollisionFlagObserver {
        public void collisionFlagsChanged(ActorLogic var1, int var2);
    }
}

