/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.tudey.data.actor.Active;
import com.threerings.tudey.server.logic.ActivityLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.MobileLogic;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveLogic
extends MobileLogic {
    protected IntMap<ActivityLogic> _activities = IntMaps.newHashIntMap();
    protected int _lastActivityStarted;

    public int getActivityAdvance() {
        return 0;
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        ActiveLogic asource = (ActiveLogic)source;
        for (IntMap.IntEntry entry : asource._activities.intEntrySet()) {
            if (this._activities.get(entry.getIntKey()) == null) continue;
            ((ActivityLogic)this._activities.get(entry.getIntKey())).transfer((Logic)entry.getValue(), refs);
        }
        this._lastActivityStarted = asource._lastActivityStarted;
    }

    @Override
    public boolean tick(int timestamp) {
        super.tick(timestamp);
        this.updateActivities(timestamp);
        Active active = (Active)this._actor;
        ActivityLogic activity = (ActivityLogic)this._activities.get(active.getActivity());
        if (activity != null) {
            int started = active.getActivityStarted();
            if (started > this._lastActivityStarted) {
                this._lastActivityStarted = started;
                activity.start(this._lastActivityStarted);
            }
            activity.tick(timestamp);
        }
        return true;
    }

    protected void updateActivities(int timestamp) {
    }
}

