/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.effect;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.math.Vector2f;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.effect.Prefireable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Effect
extends SimpleStreamableObject
implements Prefireable {
    protected ConfigReference<EffectConfig> _config;
    protected int _timestamp;
    protected EntityKey _target;
    protected Vector2f _translation = new Vector2f();
    protected float _rotation;
    protected int _clientOid;
    protected transient EffectConfig.Original _original;
    protected static final EffectConfig.Original NULL_ORIGINAL = new EffectConfig.Original();

    public Effect(ConfigReference<EffectConfig> config, int timestamp, EntityKey target, Vector2f translation, float rotation) {
        this._config = config;
        this._timestamp = timestamp;
        this._target = target;
        this._translation.set(translation);
        this._rotation = rotation;
    }

    public Effect() {
    }

    public void init(ConfigManager cfgmgr) {
        EffectConfig config = cfgmgr.getConfig(EffectConfig.class, this._config);
        this._original = config == null ? null : config.getOriginal(cfgmgr);
        this._original = this._original == null ? NULL_ORIGINAL : this._original;
    }

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
        if (preloads.add(new Preloadable.Config(EffectConfig.class, this._config))) {
            this._original.getPreloads(cfgmgr, preloads);
        }
    }

    public ConfigReference<EffectConfig> getConfig() {
        return this._config;
    }

    public int getTimestamp() {
        return this._timestamp;
    }

    public EntityKey getTarget() {
        return this._target;
    }

    public Vector2f getTranslation() {
        return this._translation;
    }

    public float getRotation() {
        return this._rotation;
    }

    public int getExpiry() {
        return this._timestamp + this._original.lifespan;
    }

    @Override
    public void setClientOid(int clientOid) {
        this._clientOid = clientOid;
    }

    @Override
    public int getClientOid() {
        return this._clientOid;
    }
}

