/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.probs.QuaternionVariable;
import com.threerings.tudey.client.cursor.PlaceableCursor;
import com.threerings.tudey.client.sprite.PlaceableSprite;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.config.ClientActionConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.TagConfig;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

public class PlaceableConfig
extends ParameterizedConfig {
    public static final Original NULL_ORIGINAL = new Prop("editor/error/model.dat");
    @Editable
    public Implementation implementation = new Prop();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    public PlaceableCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, PlaceableCursor.Implementation impl) {
        return this.implementation.getCursorImplementation(ctx, scope, impl);
    }

    public PlaceableSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PlaceableSprite.Implementation impl) {
        return this.implementation.getSpriteImplementation(ctx, scope, impl);
    }

    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<PlaceableConfig> placeable;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(PlaceableConfig.class, this.placeable);
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            PlaceableConfig config = cfgmgr.getConfig(PlaceableConfig.class, this.placeable);
            return config == null ? null : config.getOriginal(cfgmgr);
        }

        public PlaceableCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, PlaceableCursor.Implementation impl) {
            PlaceableConfig config = ctx.getConfigManager().getConfig(PlaceableConfig.class, this.placeable);
            return config == null ? null : config.getCursorImplementation(ctx, scope, impl);
        }

        public PlaceableSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PlaceableSprite.Implementation impl) {
            PlaceableConfig config = ctx.getConfigManager().getConfig(PlaceableConfig.class, this.placeable);
            return config == null ? null : config.getSpriteImplementation(ctx, scope, impl);
        }
    }

    public static class Marker
    extends Original {
        public PlaceableSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PlaceableSprite.Implementation impl) {
            if (!ScopeUtil.resolve(scope, "markersVisible", false).booleanValue()) {
                return null;
            }
            if (impl instanceof PlaceableSprite.Marker) {
                ((PlaceableSprite.Marker)impl).setConfig(this);
            } else {
                impl = new PlaceableSprite.Marker(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class StatefulProp
    extends Prop {
        @Editable(nullable=true)
        public ConfigReference<ActorConfig> actor;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.EntryLogic$StatefulProp";
        }
    }

    public static class ClickableProp
    extends Prop {
        @Editable(mode="alpha", hgroup="d")
        public Color4f defaultColor = new Color4f(0.5f, 0.5f, 0.5f, 1.0f);
        @Editable(mode="alpha", hgroup="d")
        public Color4f hoverColor = new Color4f(Color4f.WHITE);
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> defaultAnimation;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> hoverAnimation;
        @Editable
        public ClientActionConfig action = new ClientActionConfig.ControllerAction();

        public PlaceableSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PlaceableSprite.Implementation impl) {
            if (impl != null && impl.getClass() == PlaceableSprite.ClickableProp.class) {
                ((PlaceableSprite.ClickableProp)impl).setConfig(this);
            } else {
                impl = new PlaceableSprite.ClickableProp(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class Prop
    extends Original {
        @Editable(editor="mask", mode="collision", hgroup="c")
        public int collisionFlags = 1;
        @Editable(editor="mask", mode="direction", hgroup="c")
        public int directionFlags = 0;
        @Editable(editor="mask", mode="floor", hgroup="c")
        public int floorFlags = 1;

        public Prop() {
        }

        public Prop(String model) {
            this.model = new ConfigReference(model);
        }

        public int getCollisionFlags() {
            return this.collisionFlags;
        }

        public int getDirectionFlags() {
            return this.directionFlags;
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            preloads.add(new Preloadable.Model(this.model));
        }

        public PlaceableSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PlaceableSprite.Implementation impl) {
            if (impl != null && impl.getClass() == PlaceableSprite.Prop.class) {
                ((PlaceableSprite.Prop)impl).setConfig(this);
            } else {
                impl = new PlaceableSprite.Prop(ctx, scope, this);
            }
            return impl;
        }
    }

    public static abstract class Original
    extends Implementation {
        @Editable
        public boolean defaultEntrance;
        @Editable
        public QuaternionVariable rotationOffset = new QuaternionVariable.Identity();
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable
        public ShapeConfig shape = new ShapeConfig.Point();
        @Editable
        public TagConfig tags = new TagConfig();
        @Editable
        public HandlerConfig[] handlers = new HandlerConfig[0];
        @Editable
        public boolean floorTile = false;

        public int getCollisionFlags() {
            return 0;
        }

        public int getDirectionFlags() {
            return 0;
        }

        public String getLogicClassName() {
            return this.tags.getLength() == 0 && this.handlers.length == 0 && !this.defaultEntrance ? null : "com.threerings.tudey.server.logic.EntryLogic";
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            for (HandlerConfig handler : this.handlers) {
                handler.getPreloads(cfgmgr, preloads);
            }
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        public PlaceableCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, PlaceableCursor.Implementation impl) {
            if (impl instanceof PlaceableCursor.Original) {
                ((PlaceableCursor.Original)impl).setConfig(this);
            } else {
                impl = new PlaceableCursor.Original(ctx, scope, this);
            }
            return impl;
        }

        public void invalidate() {
            this.shape.invalidate();
            for (HandlerConfig handler : this.handlers) {
                handler.invalidate();
            }
        }
    }

    @EditorTypes(value={Prop.class, ClickableProp.class, StatefulProp.class, Marker.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public abstract PlaceableCursor.Implementation getCursorImplementation(TudeyContext var1, Scope var2, PlaceableCursor.Implementation var3);

        public abstract PlaceableSprite.Implementation getSpriteImplementation(TudeyContext var1, Scope var2, PlaceableSprite.Implementation var3);

        public void invalidate() {
        }
    }
}

