/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.cursor.PathCursor;
import com.threerings.tudey.client.sprite.PathSprite;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.TagConfig;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

public class PathConfig
extends ParameterizedConfig {
    public static final Original NULL_ORIGINAL = new Original(Color4f.RED);
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    public PathCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, PathCursor.Implementation impl) {
        return this.implementation.getCursorImplementation(ctx, scope, impl);
    }

    public PathSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PathSprite.Implementation impl) {
        return this.implementation.getSpriteImplementation(ctx, scope, impl);
    }

    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<PathConfig> path;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(PathConfig.class, this.path);
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            PathConfig config = cfgmgr.getConfig(PathConfig.class, this.path);
            return config == null ? null : config.getOriginal(cfgmgr);
        }

        public PathCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, PathCursor.Implementation impl) {
            PathConfig config = ctx.getConfigManager().getConfig(PathConfig.class, this.path);
            return config == null ? null : config.getCursorImplementation(ctx, scope, impl);
        }

        public PathSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PathSprite.Implementation impl) {
            PathConfig config = ctx.getConfigManager().getConfig(PathConfig.class, this.path);
            return config == null ? null : config.getSpriteImplementation(ctx, scope, impl);
        }
    }

    public static class Original
    extends Implementation {
        @Editable(mode="alpha", hgroup="c")
        @Strippable
        public Color4f color = new Color4f();
        @Editable(hgroup="c")
        @Strippable
        public boolean defaultEntrance;
        @Editable
        public TagConfig tags = new TagConfig();
        @Editable
        public HandlerConfig[] handlers = new HandlerConfig[0];

        public Original() {
        }

        public Original(Color4f color) {
            this.color.set(color);
        }

        public String getLogicClassName() {
            return this.tags.getLength() == 0 && this.handlers.length == 0 && !this.defaultEntrance ? null : "com.threerings.tudey.server.logic.EntryLogic";
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            for (HandlerConfig handler : this.handlers) {
                handler.getPreloads(cfgmgr, preloads);
            }
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        public PathCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, PathCursor.Implementation impl) {
            if (impl instanceof PathCursor.Original) {
                ((PathCursor.Original)impl).setConfig(this);
            } else {
                impl = new PathCursor.Original(ctx, scope, this);
            }
            return impl;
        }

        public PathSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, PathSprite.Implementation impl) {
            if (!ScopeUtil.resolve(scope, "markersVisible", false).booleanValue()) {
                return null;
            }
            if (impl instanceof PathSprite.Original) {
                ((PathSprite.Original)impl).setConfig(this);
            } else {
                impl = new PathSprite.Original(ctx, scope, this);
            }
            return impl;
        }

        public void invalidate() {
            for (HandlerConfig handler : this.handlers) {
                handler.invalidate();
            }
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public abstract PathCursor.Implementation getCursorImplementation(TudeyContext var1, Scope var2, PathCursor.Implementation var3);

        public abstract PathSprite.Implementation getSpriteImplementation(TudeyContext var1, Scope var2, PathSprite.Implementation var3);

        public void invalidate() {
        }
    }
}

