/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ExpressionConfig;
import com.threerings.tudey.config.RegionConfig;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={Tagged.class, InstanceOf.class, Intersecting.class, IntersectsScene.class, DistanceWithin.class, Random.class, Limit.class, All.class, Any.class, FlagSet.class, Cooldown.class, Not.class, Always.class, Evaluate.class, Action.class, Is.class, DateRange.class})
@Strippable
public abstract class ConditionConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract String getLogicClassName();

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
    }

    public void invalidate() {
    }

    public static class DateRange
    extends ConditionConfig {
        @Editable(editor="datetime", nullable=true, hgroup="a")
        public Long start;
        @Editable(editor="datetime", nullable=true, hgroup="a")
        public Long end;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$DateRange";
        }
    }

    public static class Is
    extends ConditionConfig {
        @Editable(hgroup="t")
        public boolean all;
        @Editable
        public TargetConfig target = new TargetConfig.Tagged();
        @Editable
        public TargetConfig source = new TargetConfig.Source();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Is";
        }

        public void invalidate() {
            this.target.invalidate();
            this.source.invalidate();
        }
    }

    public static class Action
    extends ConditionConfig {
        @Editable
        public ActionConfig action = new ActionConfig.SpawnActor();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Action";
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.action.getPreloads(cfgmgr, preloads);
        }

        public void invalidate() {
            this.action.invalidate();
        }
    }

    public static class Evaluate
    extends ConditionConfig {
        @Editable
        public ExpressionConfig expression = new ExpressionConfig.Constant();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Evaluate";
        }

        public void invalidate() {
            this.expression.invalidate();
        }
    }

    public static class Always
    extends ConditionConfig {
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Always";
        }
    }

    public static class Not
    extends ConditionConfig {
        @Editable
        public ConditionConfig condition = new Tagged();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Not";
        }

        public void invalidate() {
            this.condition.invalidate();
        }
    }

    public static class Cooldown
    extends ConditionConfig {
        @Editable
        public int time = 0;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Cooldown";
        }
    }

    public static class FlagSet
    extends ConditionConfig {
        @Editable(hgroup="f")
        public String flagName = "WARP";
        @Editable(hgroup="f")
        public boolean set = true;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$FlagSet";
        }

        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Any
    extends ConditionConfig {
        @Editable
        public ConditionConfig[] conditions = new ConditionConfig[0];

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Any";
        }

        public void invalidate() {
            for (ConditionConfig condition : this.conditions) {
                condition.invalidate();
            }
        }
    }

    public static class All
    extends ConditionConfig {
        @Editable
        public ConditionConfig[] conditions = new ConditionConfig[0];

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$All";
        }

        public void invalidate() {
            for (ConditionConfig condition : this.conditions) {
                condition.invalidate();
            }
        }
    }

    public static class Limit
    extends ConditionConfig {
        @Editable
        public int limit = 1;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Limit";
        }
    }

    public static class Random
    extends ConditionConfig {
        @Editable(min=0.0, max=1.0, step=0.01)
        public float probability = 0.5f;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Random";
        }
    }

    public static class DistanceWithin
    extends ConditionConfig {
        @Editable(min=0.0, step=0.1, hgroup="m")
        public float minimum;
        @Editable(min=0.0, step=0.1, hgroup="m")
        public float maximum;
        @Editable(hgroup="a")
        public boolean allFirst;
        @Editable(hgroup="a")
        public boolean allSecond;
        @Editable
        public TargetConfig first = new TargetConfig.Source();
        @Editable
        public TargetConfig second = new TargetConfig.Activator();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$DistanceWithin";
        }

        public void invalidate() {
            this.first.invalidate();
            this.second.invalidate();
        }
    }

    public static class IntersectsScene
    extends ConditionConfig {
        @Editable
        public RegionConfig region = new RegionConfig.Default();
        @Editable(editor="mask", mode="collision")
        public int collisionMask;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$IntersectsScene";
        }

        public void invalidate() {
            this.region.invalidate();
        }
    }

    public static class Intersecting
    extends ConditionConfig {
        @Editable(hgroup="a")
        public boolean allFirst;
        @Editable(hgroup="a")
        public boolean allSecond;
        @Editable
        public RegionConfig first = new RegionConfig.Default();
        @Editable
        public RegionConfig second = new RegionConfig.Default();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Intersecting";
        }

        public void invalidate() {
            this.first.invalidate();
            this.second.invalidate();
        }
    }

    public static class InstanceOf
    extends ConditionConfig {
        @Editable(hgroup="c")
        public String logicClass = "com.threerings.tudey.server.logic.PawnLogic";
        @Editable(hgroup="c")
        public boolean all;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$InstanceOf";
        }

        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Tagged
    extends ConditionConfig {
        @Editable(hgroup="t")
        public String tag = "";
        @Editable(hgroup="t")
        public boolean all;
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ConditionLogic$Tagged";
        }

        public void invalidate() {
            this.target.invalidate();
        }
    }
}

