/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.probs.FloatVariable;
import com.threerings.tudey.config.ScriptConfig;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.util.DeepObject;

@Strippable
public class BehaviorConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class WeightedBehavior
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float weight = 1.0f;
        @Editable(nullable=true)
        public ConfigReference<BehaviorConfig> behavior;
    }

    public static class Combined
    extends Original {
        @Editable(nullable=true)
        public ConfigReference<BehaviorConfig> first;
        @Editable(nullable=true)
        public ConfigReference<BehaviorConfig> second;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$Combined";
        }
    }

    public static class Scripted
    extends Original {
        @Editable
        public ScriptConfig[] steps = new ScriptConfig[0];

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$Scripted";
        }
    }

    public static class Random
    extends Evaluating {
        @Editable
        public WeightedBehavior[] behaviors = new WeightedBehavior[0];

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$Random";
        }
    }

    public static class Follow
    extends Evaluating {
        @Editable
        public TargetConfig target = new TargetConfig.Tagged();
        @Editable(min=0.0, step=0.1, hgroup="d")
        public float minimumDistance = 1.0f;
        @Editable(min=0.0, step=0.1, hgroup="d")
        public float maximumDistance = 5.0f;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$Follow";
        }

        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Patrol
    extends Evaluating {
        @Editable
        public TargetConfig target = new TargetConfig.Tagged();
        @Editable(min=-1.0, step=0.1)
        public float branchRadius = -1.0f;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$Patrol";
        }

        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class GridWander
    extends BaseWander {
        @Editable(hgroup="l")
        public GridTurn gridTurn = GridTurn.REVERSE;
        @Editable(hgroup="l")
        public boolean evaluationRotate;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$GridWander";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GridTurn {
        REVERSE,
        LEFT,
        RIGHT,
        RANDOM;

    }

    public static class Wander
    extends BaseWander {
        @Editable(min=-180.0, max=180.0, scale=0.017453292519943295)
        public FloatVariable directionChange = new FloatVariable.Uniform((float)(-Math.PI), (float)Math.PI);
        @Editable(min=0.0, step=0.1)
        public float radius = 100.0f;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$Wander";
        }
    }

    public static abstract class BaseWander
    extends Evaluating {
        @Editable(min=0.0, step=0.1)
        public FloatVariable preRotationPause = new FloatVariable.Constant(0.0f);
        @Editable(min=0.0, step=0.1)
        public FloatVariable postRotationPause = new FloatVariable.Constant(0.0f);
    }

    public static abstract class Evaluating
    extends Original {
        @Editable(min=0.0, step=0.1)
        public FloatVariable evaluationInterval = new FloatVariable.Constant(2.0f);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<BehaviorConfig> behavior;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(BehaviorConfig.class, this.behavior);
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            BehaviorConfig config = cfgmgr.getConfig(BehaviorConfig.class, this.behavior);
            return config == null ? null : config.getOriginal(cfgmgr);
        }
    }

    public static class Original
    extends Implementation {
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.BehaviorLogic$Idle";
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }
    }

    @EditorTypes(value={Original.class, Derived.class, Wander.class, GridWander.class, Patrol.class, Follow.class, Random.class, Scripted.class, Combined.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public void invalidate() {
        }
    }
}

