/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.threerings.math.Box;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.LineState;
import com.threerings.opengl.renderer.state.PointState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.scene.SimpleSceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.shape.Shape;

public class ShapeSceneElement
extends SimpleSceneElement {
    protected Shape _shape;
    protected boolean _outline;

    public ShapeSceneElement(GlContext ctx, boolean outline) {
        super(ctx);
        this._outline = outline;
    }

    public void setShape(Shape shape) {
        this._shape = shape;
        this.updateBounds();
    }

    public Shape getShape() {
        return this._shape;
    }

    public Color4f getColor() {
        ColorState cstate = (ColorState)this._batch.getStates()[2];
        return cstate.getColor();
    }

    protected RenderState[] createStates() {
        RenderState[] states = super.createStates();
        states[2] = new ColorState();
        states[8] = LineState.getInstance(3.0f);
        states[10] = PointState.getInstance(3.0f);
        return states;
    }

    protected void computeBounds(Box result) {
        if (this._shape == null) {
            result.setToEmpty();
            return;
        }
        Rect bounds = this._shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        result.getMinimumExtent().set(min.x, min.y, 0.0f);
        result.getMaximumExtent().set(max.x, max.y, 0.0f);
        result.transformLocal(this._transform);
    }

    protected void draw() {
        if (this._shape != null) {
            this._shape.draw(this._outline);
        }
    }
}

