/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.threerings.math.Box;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.LineState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.scene.SimpleSceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.util.TudeySceneMetrics;
import org.lwjgl.opengl.GL11;

public class RectangleElement
extends SimpleSceneElement {
    protected Rectangle _region = new Rectangle();
    protected int _elevation;
    protected boolean _outline;

    public RectangleElement(GlContext ctx, boolean outline) {
        super(ctx);
        this._outline = outline;
    }

    public Color4f getColor() {
        ColorState cstate = (ColorState)this._batch.getStates()[2];
        return cstate.getColor();
    }

    public Rectangle getRegion() {
        return this._region;
    }

    public void setElevation(int elevation) {
        this._elevation = elevation;
    }

    public int getElevation() {
        return this._elevation;
    }

    protected RenderState[] createStates() {
        RenderState[] states = super.createStates();
        states[2] = new ColorState();
        states[8] = LineState.getInstance(3.0f);
        return states;
    }

    protected void computeBounds(Box result) {
        float z = TudeySceneMetrics.getTileZ(this._elevation);
        result.getMinimumExtent().set(this._region.x, this._region.y, z);
        result.getMaximumExtent().set(this._region.x + this._region.width, this._region.y + this._region.height, z);
        result.transformLocal(this._transform);
    }

    protected void draw() {
        float lx = this._region.x;
        float ux = this._region.x + this._region.width;
        float ly = this._region.y;
        float uy = this._region.y + this._region.height;
        float z = TudeySceneMetrics.getTileZ(this._elevation);
        GL11.glBegin((int)(this._outline ? 2 : 9));
        GL11.glVertex3f((float)lx, (float)ly, (float)z);
        GL11.glVertex3f((float)lx, (float)uy, (float)z);
        GL11.glVertex3f((float)ux, (float)uy, (float)z);
        GL11.glVertex3f((float)ux, (float)ly, (float)z);
        GL11.glEnd();
    }
}

