/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.threerings.math.Box;
import com.threerings.math.Ray3D;
import com.threerings.math.Triangle;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.AlphaState;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.scene.SimpleSceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.data.TudeySceneModel;
import org.lwjgl.opengl.GL11;

public class AreaElement
extends SimpleSceneElement {
    protected TudeySceneModel.Vertex[] _vertices;
    protected Vector3f _center = new Vector3f();
    protected Triangle _triangle = new Triangle();
    protected boolean _visible = true;

    public AreaElement(GlContext ctx) {
        super(ctx, "Transparent");
    }

    public void setVertices(TudeySceneModel.Vertex[] vertices) {
        this._vertices = vertices;
        this.updateBounds();
    }

    public Color4f getColor() {
        ColorState cstate = (ColorState)this._batch.getStates()[2];
        return cstate.getColor();
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        if (!this._bounds.intersects(ray)) {
            return false;
        }
        ray = ray.transform(this._transform.invert());
        TudeySceneModel.Vertex v0 = this._vertices[0];
        this._triangle.getFirstVertex().set(v0.x, v0.y, v0.z);
        for (int ii = 2; ii < this._vertices.length; ++ii) {
            TudeySceneModel.Vertex v1 = this._vertices[ii - 1];
            TudeySceneModel.Vertex v2 = this._vertices[ii];
            this._triangle.getSecondVertex().set(v1.x, v1.y, v1.z);
            this._triangle.getThirdVertex().set(v2.x, v2.y, v2.z);
            if (!this._triangle.getIntersection(ray, result) && !this._triangle.flipLocal().getIntersection(ray, result)) continue;
            this._transform.transformPointLocal(result);
            return true;
        }
        return false;
    }

    protected RenderState[] createStates() {
        RenderState[] states = super.createStates();
        states[0] = AlphaState.PREMULTIPLIED;
        states[2] = new ColorState();
        states[5] = DepthState.TEST;
        return states;
    }

    protected void computeBounds(Box result) {
        result.setToEmpty();
        if (this._vertices == null) {
            return;
        }
        for (TudeySceneModel.Vertex vertex : this._vertices) {
            result.addLocal(new Vector3f(vertex.x, vertex.y, vertex.z));
        }
        result.getCenter(this._center);
        result.transformLocal(this._transform);
    }

    protected void draw() {
        if (this._vertices == null || !this._visible) {
            return;
        }
        GL11.glBegin((int)9);
        for (TudeySceneModel.Vertex vertex : this._vertices) {
            GL11.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
        }
        GL11.glEnd();
    }

    protected Vector3f getCenter() {
        return this._center;
    }
}

