/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.samskivert.util.ListUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.SimpleScope;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Vector3f;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.util.ShapeSceneElement;
import com.threerings.tudey.config.PathConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.TudeyContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSprite
extends EntrySprite
implements ConfigUpdateListener<PathConfig> {
    public static final String VERTEX_MODEL = "editor/marker/vertex/model.dat";
    public static final String EDGE_MODEL = "editor/marker/edge/model.dat";
    protected TudeySceneModel.PathEntry _entry;
    protected PathConfig _config = INVALID_CONFIG;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static PathConfig INVALID_CONFIG = new PathConfig();
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public static float updateVertices(TudeySceneModel.Vertex[] vertices, Model[] models) {
        float minz = Float.MAX_VALUE;
        for (int ii = 0; ii < models.length; ++ii) {
            TudeySceneModel.Vertex vertex = vertices[ii];
            Model model = models[ii];
            model.getLocalTransform().getTranslation().set(vertex.x, vertex.y, vertex.z);
            model.updateBounds();
            minz = Math.min(minz, vertex.z);
        }
        return minz;
    }

    public static void updateEdges(TudeySceneModel.Vertex[] vertices, Model[] models) {
        Vector3f translation = new Vector3f();
        Vector3f scale = new Vector3f();
        Vector3f vector = new Vector3f();
        Quaternion rotation = new Quaternion();
        for (int ii = 0; ii < models.length; ++ii) {
            TudeySceneModel.Vertex v1 = vertices[ii];
            TudeySceneModel.Vertex v2 = vertices[(ii + 1) % vertices.length];
            vector.set(v2.x - v1.x, v2.y - v1.y, v2.z - v1.z);
            float length = vector.length();
            if (length > 1.0E-6f) {
                rotation.fromAnglesXZ(FloatMath.asin(vector.z / length), FloatMath.atan2(-vector.x, vector.y));
            } else {
                rotation.set(Quaternion.IDENTITY);
            }
            Model model = models[ii];
            model.getLocalTransform().set(translation.set(v1.x, v1.y, v1.z), rotation, scale.set(1.0f, length, 1.0f));
            model.updateBounds();
        }
    }

    public static Model[] maybeResize(Model[] omodels, int ncount, TudeyContext ctx, Scene scene, String name, ColorState colorState, Object userObject) {
        int ii;
        if (omodels.length == ncount) {
            return omodels;
        }
        Model[] nmodels = new Model[ncount];
        System.arraycopy(omodels, 0, nmodels, 0, Math.min(omodels.length, ncount));
        for (ii = omodels.length; ii < ncount; ++ii) {
            Model model = nmodels[ii] = new Model(ctx);
            model.setColorState(colorState);
            model.setUserObject(userObject);
            scene.add(model);
            model.setConfig(name);
        }
        for (ii = ncount; ii < omodels.length; ++ii) {
            scene.remove(omodels[ii]);
        }
        return nmodels;
    }

    public PathSprite(TudeyContext ctx, TudeySceneView view, TudeySceneModel.PathEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    public int getVertexIndex(Model model) {
        return this._impl.getVertexIndex(model);
    }

    public int getEdgeIndex(Model model) {
        return this._impl.getEdgeIndex(model);
    }

    @Override
    public void configUpdated(ConfigEvent<PathConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void scopeUpdated(ScopeEvent event) {
        super.scopeUpdated(event);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.PathEntry)entry;
        this.setConfig(this._entry.path);
        this._impl.update(this._entry);
    }

    @Override
    public void setVisible(boolean visible) {
        this._impl.setVisible(visible);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<PathConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(PathConfig.class, ref));
    }

    protected void setConfig(PathConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        PathConfig.Original original = this._config == null ? null : this._config.getOriginal(this._ctx.getConfigManager());
        original = original == null ? PathConfig.NULL_ORIGINAL : original;
        Implementation nimpl = original.getSpriteImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected Model[] _vertices = new Model[0];
        protected Model[] _edges = new Model[0];
        protected ColorState _colorState = new ColorState();
        protected ShapeSceneElement _footprint;
        @Bound
        protected Scene _scene;

        public Original(TudeyContext ctx, Scope parentScope, PathConfig.Original config) {
            super(parentScope);
            this._ctx = ctx;
            this.setConfig(config);
        }

        public void setConfig(PathConfig.Original config) {
            this._colorState.getColor().set(config.color);
            boolean selected = ((PathSprite)this._parentScope).isSelected();
            if (selected && this._footprint == null) {
                this._footprint = new ShapeSceneElement((GlContext)this._ctx, true);
                this._footprint.getColor().set(EntrySprite.SELECTED_COLOR);
                this._scene.add(this._footprint);
            } else if (!selected && this._footprint != null) {
                this._scene.remove(this._footprint);
                this._footprint = null;
            }
        }

        public int getVertexIndex(Model model) {
            return ListUtil.indexOfRef((Object[])this._vertices, (Object)model);
        }

        public int getEdgeIndex(Model model) {
            return ListUtil.indexOfRef((Object[])this._edges, (Object)model);
        }

        public void update(TudeySceneModel.PathEntry entry) {
            this._vertices = PathSprite.maybeResize(this._vertices, entry.vertices.length, this._ctx, this._scene, PathSprite.VERTEX_MODEL, this._colorState, this._parentScope);
            float minz = PathSprite.updateVertices(entry.vertices, this._vertices);
            this._edges = PathSprite.maybeResize(this._edges, entry.vertices.length - 1, this._ctx, this._scene, PathSprite.EDGE_MODEL, this._colorState, this._parentScope);
            PathSprite.updateEdges(entry.vertices, this._edges);
            if (this._footprint != null) {
                this._footprint.getTransform().getTranslation().z = minz;
                this._footprint.setShape(entry.createShape(this._ctx.getConfigManager()));
            }
        }

        public void setVisible(boolean visible) {
            for (Model vertex : this._vertices) {
                vertex.setVisible(visible);
            }
            for (Model edge : this._edges) {
                edge.setVisible(visible);
            }
        }

        public void dispose() {
            super.dispose();
            this._scene.removeAll(this._vertices);
            this._scene.removeAll(this._edges);
            if (this._footprint != null) {
                this._scene.remove(this._footprint);
            }
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public int getVertexIndex(Model model) {
            return -1;
        }

        public int getEdgeIndex(Model model) {
            return -1;
        }

        public void update(TudeySceneModel.PathEntry entry) {
        }

        public void setVisible(boolean visible) {
        }

        public String getScopeName() {
            return "impl";
        }
    }
}

