/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.cursor;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.math.Transform2D;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.util.Tickable;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.cursor.EntryCursor;
import com.threerings.tudey.client.util.ShapeConfigElement;
import com.threerings.tudey.config.PlaceableConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.TudeyContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceableCursor
extends EntryCursor
implements ConfigUpdateListener<PlaceableConfig> {
    protected TudeySceneModel.PlaceableEntry _entry;
    protected PlaceableConfig _config;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public PlaceableCursor(TudeyContext ctx, TudeySceneView view, TudeySceneModel.PlaceableEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    @Override
    public void configUpdated(ConfigEvent<PlaceableConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public Shape getShape() {
        return this._impl.getShape();
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.PlaceableEntry)entry;
        this.setConfig(this._entry.placeable);
        this._impl.update(this._entry);
    }

    @Override
    public void tick(float elapsed) {
        this._impl.tick(elapsed);
    }

    @Override
    public void composite() {
        this._impl.composite();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<PlaceableConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(PlaceableConfig.class, ref));
    }

    protected void setConfig(PlaceableConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getCursorImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Original
    extends Implementation {
        protected Model _model;
        protected ShapeConfigElement _footprint;
        protected Transform2D _transform = new Transform2D();
        protected Shape _localShape;
        protected Shape _worldShape;

        public Original(TudeyContext ctx, Scope parentScope, PlaceableConfig.Original config) {
            super(parentScope);
            this._model = new Model(ctx);
            this._model.setParentScope(this);
            this._model.setRenderScheme("Translucent");
            this._model.setColorState(new ColorState());
            this._model.getColorState().getColor().set(0.5f, 0.5f, 0.5f, 0.45f);
            this._footprint = new ShapeConfigElement(ctx);
            this._footprint.getColor().set(EntryCursor.FOOTPRINT_COLOR);
            this.setConfig(config);
        }

        public void setConfig(PlaceableConfig.Original config) {
            this._model.setConfig(config.model);
            this._footprint.setConfig(config.shape, true);
            this._localShape = config.shape.getShape();
        }

        public Shape getShape() {
            return this._worldShape;
        }

        public void update(TudeySceneModel.PlaceableEntry entry) {
            this._model.setLocalTransform(entry.transform);
            this._footprint.setTransform(entry.transform);
            this._transform.set(entry.transform);
            this._worldShape = this._localShape.transform(this._transform, this._worldShape);
        }

        public void tick(float elapsed) {
            this._model.tick(elapsed);
        }

        public void composite() {
            this._model.composite();
            this._footprint.composite();
        }
    }

    public static abstract class Implementation
    extends SimpleScope
    implements Tickable,
    Compositable {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public Shape getShape() {
            return null;
        }

        public void update(TudeySceneModel.PlaceableEntry entry) {
        }

        public void tick(float elapsed) {
        }

        public void composite() {
        }

        public String getScopeName() {
            return "impl";
        }
    }
}

