/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing;

import com.samskivert.util.ListUtil;
import com.threerings.swing.PrefsTreeNode;
import com.threerings.util.ToolUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PrefsTree
extends JTree {
    protected Preferences _prefs;

    public PrefsTree(Preferences prefs) {
        this._prefs = prefs;
        this.setModel(new DefaultTreeModel(new PrefsTreeNode(this._prefs), true){

            public void valueForPathChanged(TreePath path, Object newValue) {
                TreePath selection = PrefsTree.this.getSelectionPath();
                PrefsTreeNode node = (PrefsTreeNode)path.getLastPathComponent();
                PrefsTreeNode parent = (PrefsTreeNode)node.getParent();
                PrefsTree.this.removeNodeFromParent(node);
                node.setUserObject(newValue);
                PrefsTree.this.insertNodeInto(node, parent);
                node.expandPaths(PrefsTree.this);
                PrefsTree.this.setSelectionPath(selection);
            }
        });
        this.setRootVisible(false);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                ((PrefsTreeNode)event.getPath().getLastPathComponent()).setExpanded(PrefsTree.this, PrefsTree.this._prefs, true);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                ((PrefsTreeNode)event.getPath().getLastPathComponent()).setExpanded(PrefsTree.this, PrefsTree.this._prefs, false);
            }
        });
        this.setDragEnabled(true);
        final DataFlavor nflavor = ToolUtil.createLocalFlavor(PrefsTreeNode.class);
        this.setTransferHandler(new TransferHandler(){

            public int getSourceActions(JComponent comp) {
                return 2;
            }

            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return ListUtil.containsRef((Object[])flavors, (Object)nflavor);
            }

            public boolean importData(JComponent comp, Transferable t) {
                try {
                    PrefsTreeNode node = (PrefsTreeNode)t.getTransferData(nflavor);
                    PrefsTreeNode selected = PrefsTree.this.getSelectedNode();
                    if (selected == node) {
                        return false;
                    }
                    PrefsTreeNode parent = selected == null ? (PrefsTreeNode)PrefsTree.this.getModel().getRoot() : (selected.getAllowsChildren() ? selected : (PrefsTreeNode)selected.getParent());
                    if (node.getParent() == parent) {
                        return false;
                    }
                    PrefsTree.this.removeNodeFromParent(node);
                    PrefsTree.this.insertNodeInto(node, parent);
                    node.expandPaths(PrefsTree.this);
                    PrefsTree.this.setSelectionPath(new TreePath(node.getPath()));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            protected Transferable createTransferable(JComponent c) {
                final PrefsTreeNode node = PrefsTree.this.getSelectedNode();
                if (node == null) {
                    return null;
                }
                return new Transferable(){

                    public Object getTransferData(DataFlavor flavor) {
                        return node;
                    }

                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{nflavor};
                    }

                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return flavor == nflavor;
                    }
                };
            }

            protected void exportDone(JComponent source, Transferable data, int action) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 127) {
                    PrefsTree.this.removeSelectedNode();
                    event.consume();
                }
            }
        });
        this.getRootNode().expandPaths(this);
    }

    public PrefsTreeNode getRootNode() {
        return (PrefsTreeNode)this.getModel().getRoot();
    }

    public PrefsTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        return path == null ? null : (PrefsTreeNode)path.getLastPathComponent();
    }

    public void insertNewNode(String name, Object value) {
        PrefsTreeNode node = new PrefsTreeNode(name, value);
        this.insertNodeInto(node, this.getRootNode());
        this.startEditingAtPath(new TreePath(node.getPath()));
    }

    public void removeSelectedNode() {
        PrefsTreeNode select;
        PrefsTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        PrefsTreeNode parent = (PrefsTreeNode)node.getParent();
        int idx = parent.getIndex(node);
        this.removeNodeFromParent(node);
        int ccount = parent.getChildCount();
        if (ccount > 0) {
            select = (PrefsTreeNode)parent.getChildAt(Math.min(idx, ccount - 1));
        } else if (!parent.isRoot()) {
            select = parent;
        } else {
            return;
        }
        this.setSelectionPath(new TreePath(select.getPath()));
    }

    public void removeNodeFromParent(PrefsTreeNode node) {
        node.removeFromPreferences(this._prefs);
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
    }

    public void insertNodeInto(PrefsTreeNode node, PrefsTreeNode parent) {
        String base = (String)node.getUserObject();
        node.setUserObject(parent.findNameForChild(base));
        ((DefaultTreeModel)this.getModel()).insertNodeInto(node, parent, parent.getInsertionIndex(node));
        node.addToPreferences(this._prefs);
    }
}

