/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.probs;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import com.threerings.util.DeepObject;

@EditorTypes(value={Constant.class, Uniform.class}, label="distribution")
public abstract class VectorVariable
extends DeepObject
implements Exportable {
    public abstract Vector3f getValue(Vector3f var1);

    public abstract Vector3f getMean(Vector3f var1);

    public static class Uniform
    extends VectorVariable {
        @Editable(hgroup="range", step=-Infinity, scale=-Infinity)
        public Vector3f minimum = new Vector3f();
        @Editable(hgroup="range", step=-Infinity, scale=-Infinity)
        public Vector3f maximum = new Vector3f();

        public Uniform(VectorVariable variable) {
            this.maximum.set(variable.getMean(this.minimum));
        }

        public Uniform() {
        }

        public Vector3f getValue(Vector3f result) {
            return result.set(FloatMath.random(this.minimum.x, this.maximum.x), FloatMath.random(this.minimum.y, this.maximum.y), FloatMath.random(this.minimum.z, this.maximum.z));
        }

        public Vector3f getMean(Vector3f result) {
            return this.minimum.add(this.maximum, result).multLocal(0.5f);
        }
    }

    public static class Constant
    extends VectorVariable {
        @Editable(step=-Infinity, scale=-Infinity)
        public Vector3f value = new Vector3f();

        public Constant(VectorVariable variable) {
            variable.getMean(this.value);
        }

        public Constant() {
        }

        public Vector3f getValue(Vector3f result) {
            return result.set(this.value);
        }

        public Vector3f getMean(Vector3f result) {
            return result.set(this.value);
        }
    }
}

