/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.probs;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Vector3f;
import com.threerings.util.DeepObject;

@EditorTypes(value={Identity.class, Constant.class, Uniform.class, Random.class}, label="distribution")
public abstract class QuaternionVariable
extends DeepObject
implements Exportable {
    public abstract Quaternion getValue(Quaternion var1);

    public abstract Quaternion getMean(Quaternion var1);

    public static class Random
    extends QuaternionVariable {
        public Quaternion getValue(Quaternion result) {
            return result.randomize();
        }

        public Quaternion getMean(Quaternion result) {
            return result.set(Quaternion.IDENTITY);
        }
    }

    public static class Uniform
    extends QuaternionVariable {
        @Editable(hgroup="range", mode="angles")
        public Vector3f minimum = new Vector3f();
        @Editable(hgroup="range", mode="angles")
        public Vector3f maximum = new Vector3f();

        public Uniform(QuaternionVariable variable) {
            Quaternion mean = variable.getMean(new Quaternion());
            this.maximum.set(mean.toAngles(this.minimum));
        }

        public Uniform() {
        }

        public Quaternion getValue(Quaternion result) {
            return result.fromAngles(FloatMath.random(this.minimum.x, this.maximum.x), FloatMath.asin(FloatMath.random(FloatMath.sin(this.minimum.y), FloatMath.sin(this.maximum.y))), FloatMath.random(this.minimum.z, this.maximum.z));
        }

        public Quaternion getMean(Quaternion result) {
            return result.fromAngles((this.minimum.x + this.maximum.x) * 0.5f, FloatMath.asin((FloatMath.sin(this.minimum.y) + FloatMath.sin(this.maximum.y)) * 0.5f), (this.minimum.z + this.maximum.z) * 0.5f);
        }
    }

    public static class Constant
    extends QuaternionVariable {
        @Editable
        public Quaternion value = new Quaternion();

        public Constant(QuaternionVariable variable) {
            variable.getMean(this.value);
        }

        public Constant() {
        }

        public Quaternion getValue(Quaternion result) {
            return result.set(this.value);
        }

        public Quaternion getMean(Quaternion result) {
            return result.set(this.value);
        }
    }

    public static class Identity
    extends QuaternionVariable {
        public Quaternion getValue(Quaternion result) {
            return result.set(Quaternion.IDENTITY);
        }

        public Quaternion getMean(Quaternion result) {
            return result.set(Quaternion.IDENTITY);
        }
    }
}

