/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.probs;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.util.DeepObject;

@EditorTypes(value={Constant.class, Uniform.class}, label="distribution")
public abstract class ColorVariable
extends DeepObject
implements Exportable,
Streamable {
    public abstract Color4f getValue(Color4f var1);

    public abstract Color4f getMean(Color4f var1);

    public static class Uniform
    extends ColorVariable {
        @Editable(mode="%INHERIT%")
        public Color4f minimum = new Color4f();
        @Editable(mode="%INHERIT%")
        public Color4f maximum = new Color4f();

        public Uniform(ColorVariable variable) {
            this.maximum.set(variable.getMean(this.minimum));
        }

        public Uniform() {
        }

        public Color4f getValue(Color4f result) {
            return result.set(FloatMath.random(this.minimum.r, this.maximum.r), FloatMath.random(this.minimum.g, this.maximum.g), FloatMath.random(this.minimum.b, this.maximum.b), FloatMath.random(this.minimum.a, this.maximum.a));
        }

        public Color4f getMean(Color4f result) {
            return this.minimum.add(this.maximum, result).multLocal(0.5f);
        }
    }

    public static class Constant
    extends ColorVariable {
        @Editable(mode="%INHERIT%")
        public Color4f value = new Color4f();

        public Constant(ColorVariable variable) {
            variable.getMean(this.value);
        }

        public Constant() {
        }

        public Color4f getValue(Color4f result) {
            return result.set(this.value);
        }

        public Color4f getMean(Color4f result) {
            return result.set(this.value);
        }
    }
}

