/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.renderer.SimpleBatch;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.util.GlContext;

public abstract class SimpleRenderable
implements Compositable,
Enqueueable {
    protected GlContext _ctx;
    protected RenderQueue _queue;
    protected SimpleBatch _batch;
    protected int _priority;

    public SimpleRenderable(GlContext ctx) {
        this(ctx, "Opaque");
    }

    public SimpleRenderable(GlContext ctx, String queue) {
        this(ctx, queue, 0);
    }

    public SimpleRenderable(GlContext ctx, String queue, int priority) {
        this(ctx, queue, priority, false, 0);
    }

    public SimpleRenderable(GlContext ctx, String queue, int priority, boolean modifiesColorState, int primitiveCount) {
        this._ctx = ctx;
        this._queue = ctx.getCompositor().getQueue(queue);
        this._batch = this.createBatch(modifiesColorState, primitiveCount);
        this._priority = priority;
    }

    public RenderState[] getStates() {
        return this._batch.getStates();
    }

    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
    }

    public void enqueue() {
        this._queue.add(this._batch, this._priority);
    }

    protected SimpleRenderable() {
    }

    protected SimpleBatch createBatch(final boolean modifiesColorState, final int primitiveCount) {
        return new SimpleBatch(this.createStates(), new SimpleBatch.DrawCommand(){

            public boolean call() {
                SimpleRenderable.this.draw();
                return modifiesColorState;
            }

            public int getPrimitiveCount() {
                return primitiveCount;
            }
        });
    }

    protected RenderState[] createStates() {
        RenderState[] states = RenderState.createDefaultSet();
        states[1] = null;
        states[5] = DepthState.TEST_WRITE;
        states[9] = null;
        return states;
    }

    protected void draw() {
        throw new RuntimeException("Override draw method to render.");
    }
}

