/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.google.common.collect.Maps;
import com.threerings.opengl.util.GlContext;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public abstract class ResourceCache {
    protected GlContext _ctx;
    protected boolean _checkTimestamps;

    public ResourceCache(GlContext ctx, boolean checkTimestamps) {
        this._ctx = ctx;
        this._checkTimestamps = checkTimestamps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CachedResource<T>
    extends SoftReference<T> {
        protected File _file;
        protected long _lastModified;

        public CachedResource(T resource, File file) {
            super(resource);
            this._file = file;
            this._lastModified = file.lastModified();
        }

        public boolean wasModified() {
            return this._file.lastModified() > this._lastModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Subcache<K, V> {
        protected HashMap<K, CachedResource<V>> _resources = Maps.newHashMap();

        protected Subcache() {
        }

        public V getResource(K key) {
            Object resource;
            CachedResource<V> cached = this._resources.get(key);
            if (!(cached == null || (resource = cached.get()) == null || ResourceCache.this._checkTimestamps && cached.wasModified())) {
                return (V)resource;
            }
            resource = this.loadResource(key);
            this._resources.put(key, new CachedResource(resource, this.getResourceFile(key)));
            return (V)resource;
        }

        public void clear() {
            this._resources.clear();
        }

        protected abstract V loadResource(K var1);

        protected File getResourceFile(K key) {
            return ResourceCache.this._ctx.getResourceManager().getResourceFile(this.getResourcePath(key));
        }

        protected abstract String getResourcePath(K var1);
    }
}

