/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.google.common.collect.Lists;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreloadableSet
extends HashSet<Preloadable> {
    protected GlContext _ctx;
    protected List<Preloadable> _remaining;
    protected int _preloaded;

    public PreloadableSet(GlContext ctx) {
        this._ctx = ctx;
    }

    public float preloadBatch() {
        return this.preloadBatch(100L);
    }

    public float preloadBatch(long duration) {
        if (this._remaining != null && this._remaining.isEmpty()) {
            return 1.0f;
        }
        if (this._remaining == null) {
            this._remaining = Lists.newArrayList((Iterable)this);
        }
        long end = System.currentTimeMillis() + duration;
        for (int ii = this._remaining.size() - 1; ii >= 0 && System.currentTimeMillis() < end; --ii) {
            this._remaining.remove(ii).preload(this._ctx);
            ++this._preloaded;
        }
        if (this._remaining.isEmpty()) {
            return 1.0f;
        }
        return (float)this._preloaded / (float)this.size();
    }

    @Override
    public boolean add(Preloadable preloadable) {
        if (!super.add(preloadable)) {
            return false;
        }
        if (this._remaining != null) {
            preloadable.preload(this._ctx);
            ++this._preloaded;
        }
        return true;
    }
}

