/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlUtil {
    public static int nextPowerOfTwo(int value) {
        return Integer.bitCount(value) > 1 ? Integer.highestOneBit(value) << 1 : value;
    }

    public static <T> void divide(T[] a, Comparator<? super T> comp) {
        int left = 0;
        int right = a.length - 1;
        int k = a.length / 2;
        int pivotIndex;
        int pivotNewIndex;
        while (k != (pivotNewIndex = GlUtil.partition(a, left, right, pivotIndex = (left + right) / 2, comp))) {
            if (k < pivotNewIndex) {
                right = pivotNewIndex - 1;
                continue;
            }
            left = pivotNewIndex + 1;
        }
        return;
    }

    protected static <T> int partition(T[] a, int left, int right, int pivotIndex, Comparator<? super T> comp) {
        T pivotValue = a[pivotIndex];
        GlUtil.swap(a, pivotIndex, right);
        int storeIndex = left;
        for (int ii = left; ii < right; ++ii) {
            if (comp.compare(a[ii], pivotValue) > 0) continue;
            GlUtil.swap(a, storeIndex, ii);
            ++storeIndex;
        }
        GlUtil.swap(a, right, storeIndex);
        return storeIndex;
    }

    protected static <T> void swap(T[] a, int idx1, int idx2) {
        T tmp = a[idx1];
        a[idx1] = a[idx2];
        a[idx2] = tmp;
    }
}

