/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene;

import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.math.Box;
import com.threerings.math.Transform3D;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.scene.config.ViewerAffecterConfig;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;

public class ViewerAffecter
extends Model.Implementation {
    protected GlContext _ctx;
    protected ViewerAffecterConfig _config;
    protected ViewerEffect _effect;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();
    protected boolean _visible = true;

    public ViewerAffecter(GlContext ctx, Scope parentScope, ViewerAffecterConfig config) {
        super(parentScope);
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, ViewerAffecterConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    public boolean hasCompleted() {
        return this._effect.hasCompleted();
    }

    public void setVisible(boolean visible) {
        if (this._visible != visible) {
            this._visible = visible;
            Scene scene = ((Model)this._parentScope).getScene(this);
            if (visible) {
                scene.add(this._effect);
            } else {
                scene.remove(this._effect);
            }
        }
    }

    public void reset() {
        this._effect.reset();
    }

    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    public Box getBounds() {
        return this._bounds;
    }

    public void updateBounds() {
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this._config.extent.transformBounds(this._worldTransform, this._nbounds);
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
            Scene scene = ((Model)this._parentScope).getScene(this);
            if (scene != null) {
                scene.boundsWillChange(this._effect);
            }
            this._effect.getBounds().set(this._nbounds);
            if (scene != null) {
                scene.boundsDidChange(this._effect);
            }
        }
    }

    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
    }

    public void wasAdded() {
        if (this._visible) {
            ((Model)this._parentScope).getScene(this).add(this._effect);
        }
    }

    public void willBeRemoved() {
        if (this._visible) {
            ((Model)this._parentScope).getScene(this).remove(this._effect);
        }
    }

    protected void updateFromConfig() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        if (this._visible && scene != null && this._effect != null) {
            scene.remove(this._effect);
        }
        this._influenceFlags = this._config.influences.getFlags();
        this._effect = this._config.effect.getViewerEffect(this._ctx, this, this._effect);
        this._effect.getBounds().set(this._bounds);
        if (this._visible && scene != null) {
            scene.add(this._effect);
        }
        this.updateBounds();
    }
}

