/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene;

import com.threerings.math.Box;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.scene.SceneInfluenceSet;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.SimpleTransformable;

public abstract class SimpleSceneElement
extends SimpleTransformable
implements SceneElement {
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();
    protected SceneElement.TickPolicy _tickPolicy = SceneElement.TickPolicy.NEVER;
    protected Object _userObject;
    protected Scene _scene;
    protected SceneInfluenceSet _influences = new SceneInfluenceSet();
    protected int _lastVisit;

    public SimpleSceneElement(GlContext ctx) {
        this(ctx, "Opaque");
    }

    public SimpleSceneElement(GlContext ctx, String queue) {
        this(ctx, queue, 0);
    }

    public SimpleSceneElement(GlContext ctx, String queue, int priority) {
        this(ctx, queue, priority, false, 0);
    }

    public SimpleSceneElement(GlContext ctx, String queue, int priority, boolean modifiesColorState, int primitiveCount) {
        super(ctx, queue, priority, modifiesColorState, primitiveCount);
    }

    public void setTickPolicy(SceneElement.TickPolicy policy) {
        if (this._tickPolicy == policy) {
            return;
        }
        if (this._scene != null) {
            this._scene.tickPolicyWillChange(this);
        }
        this._tickPolicy = policy;
        if (this._scene != null) {
            this._scene.tickPolicyDidChange(this);
        }
    }

    public void setUserObject(Object object) {
        this._userObject = object;
    }

    public void setTransform(Transform3D transform) {
        this._transform.set(transform);
        this._transform.promote(2);
        this.updateBounds();
    }

    public void updateBounds() {
        this.computeBounds(this._nbounds);
        if (!this._bounds.equals(this._nbounds)) {
            this.boundsWillChange();
            this._bounds.set(this._nbounds);
            this.boundsDidChange();
        }
    }

    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public void wasAdded(Scene scene) {
        this._scene = scene;
    }

    public void willBeRemoved() {
        this._scene = null;
    }

    public void setInfluences(SceneInfluenceSet influences) {
        this._influences.clear();
        this._influences.addAll(influences);
    }

    public Box getBounds() {
        return this._bounds;
    }

    public boolean updateLastVisit(int visit) {
        if (this._lastVisit == visit) {
            return false;
        }
        this._lastVisit = visit;
        return true;
    }

    public void tick(float elapsed) {
        this.updateBounds();
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        return false;
    }

    protected void computeBounds(Box result) {
        this.getLocalBounds().transform(this._transform, result);
    }

    protected Box getLocalBounds() {
        return Box.ZERO;
    }

    protected void boundsWillChange() {
        if (this._scene != null) {
            this._scene.boundsWillChange(this);
        }
    }

    protected void boundsDidChange() {
        if (this._scene != null) {
            this._scene.boundsDidChange(this);
        }
    }
}

