/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.math.Transform3D;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.opengl.renderer.config.TextureConfig;
import com.threerings.opengl.renderer.config.TextureCoordGenConfig;
import com.threerings.opengl.renderer.config.TextureEnvironmentConfig;
import com.threerings.opengl.renderer.state.TextureState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureUnitConfig
extends DeepObject
implements Exportable {
    @Editable(nullable=true)
    public ConfigReference<TextureConfig> texture;
    @Editable
    public TextureEnvironmentConfig environment = new TextureEnvironmentConfig.Modulate();
    @Editable(min=0.0)
    public int coordSet;
    @Editable(nullable=true)
    public TextureCoordGenConfig coordGenS;
    @Editable(nullable=true)
    public TextureCoordGenConfig coordGenT;
    @Editable(nullable=true)
    @EditorTypes(value={TextureCoordGenConfig.ObjectLinear.class, TextureCoordGenConfig.EyeLinear.class, TextureCoordGenConfig.NormalMap.class, TextureCoordGenConfig.ReflectionMap.class})
    public TextureCoordGenConfig coordGenR;
    @Editable(nullable=true)
    @EditorTypes(value={TextureCoordGenConfig.ObjectLinear.class, TextureCoordGenConfig.EyeLinear.class})
    public TextureCoordGenConfig coordGenQ;
    @Editable(step=0.01)
    public Transform3D transform = new Transform3D();

    public boolean isSupported(GlContext ctx, boolean fallback) {
        if (!this.environment.isSupported(fallback) || this.coordGenS != null && !this.coordGenS.isSupported(fallback) || this.coordGenT != null && !this.coordGenT.isSupported(fallback) || this.coordGenR != null && !this.coordGenR.isSupported(fallback) || this.coordGenQ != null && !this.coordGenQ.isSupported(fallback)) {
            return false;
        }
        TextureConfig config = this.getTextureConfig(ctx);
        return config == null || config.isSupported(ctx, fallback);
    }

    public TextureUnit createUnit(GlContext ctx, TextureState state, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
        TextureUnit unit = new TextureUnit();
        TextureConfig config = this.getTextureConfig(ctx);
        if (config != null) {
            unit.texture = config.getTexture(ctx, state, unit, scope, adders, updaters);
        }
        this.environment.configure(unit);
        if (this.coordGenS != null) {
            unit.genModeS = this.coordGenS.getModeAndPlane(unit.genPlaneS);
        }
        if (this.coordGenT != null) {
            unit.genModeT = this.coordGenT.getModeAndPlane(unit.genPlaneT);
        }
        if (this.coordGenR != null) {
            unit.genModeR = this.coordGenR.getModeAndPlane(unit.genPlaneR);
        }
        if (this.coordGenQ != null) {
            unit.genModeQ = this.coordGenQ.getModeAndPlane(unit.genPlaneQ);
        }
        unit.transform.set(this.transform);
        return unit;
    }

    protected TextureConfig getTextureConfig(GlContext ctx) {
        return this.texture == null ? null : ctx.getConfigManager().getConfig(TextureConfig.class, this.texture);
    }
}

