/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.Vector4f;
import com.threerings.util.DeepObject;
import org.lwjgl.opengl.GLContext;

@EditorTypes(value={ObjectLinear.class, EyeLinear.class, SphereMap.class, NormalMap.class, ReflectionMap.class})
public abstract class TextureCoordGenConfig
extends DeepObject
implements Exportable {
    public boolean isSupported(boolean fallback) {
        return true;
    }

    public abstract int getModeAndPlane(Vector4f var1);

    public boolean usesNormals() {
        return true;
    }

    public static class ReflectionMap
    extends TextureCoordGenConfig {
        public boolean isSupported(boolean fallback) {
            return GLContext.getCapabilities().GL_ARB_texture_cube_map;
        }

        public int getModeAndPlane(Vector4f plane) {
            return 34066;
        }
    }

    public static class NormalMap
    extends TextureCoordGenConfig {
        public boolean isSupported(boolean fallback) {
            return GLContext.getCapabilities().GL_ARB_texture_cube_map;
        }

        public int getModeAndPlane(Vector4f plane) {
            return 34065;
        }
    }

    public static class SphereMap
    extends TextureCoordGenConfig {
        public int getModeAndPlane(Vector4f plane) {
            return 9218;
        }
    }

    public static class EyeLinear
    extends Linear {
        public int getModeAndPlane(Vector4f plane) {
            plane.set(this.x, this.y, this.z, this.w);
            return 9216;
        }
    }

    public static class ObjectLinear
    extends Linear {
        public int getModeAndPlane(Vector4f plane) {
            plane.set(this.x, this.y, this.z, this.w);
            return 9217;
        }
    }

    public static abstract class Linear
    extends TextureCoordGenConfig {
        @Editable(step=0.01, hgroup="p")
        public float x;
        @Editable(step=0.01, hgroup="p")
        public float y;
        @Editable(step=0.01, hgroup="p")
        public float z;
        @Editable(step=0.01, hgroup="p")
        public float w;

        public boolean usesNormals() {
            return false;
        }
    }
}

