/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.util.GlUtil;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GLContext;

public class Texture3D
extends Texture {
    protected int _width;
    protected int _height;
    protected int _depth;

    public Texture3D(Renderer renderer) {
        super(renderer, 32879);
    }

    public void setImage(int format, int width, int height, int depth, boolean border, boolean mipmap) {
        this.setImage(0, format, width, height, depth, border);
        if (mipmap) {
            int ww = this._width / 2;
            int hh = this._height / 2;
            int ll = 1;
            for (int dd = this._depth / 2; ww > 0 || hh > 0 || dd > 0; ww /= 2, hh /= 2, dd /= 2) {
                this.setImage(ll, format, Math.max(ww, 1), Math.max(hh, 1), Math.max(dd, 1), border);
                ++ll;
            }
        }
    }

    public void setImage(int level, int format, int width, int height, int depth, boolean border) {
        this.setImage(level, format, width, height, depth, border, Texture3D.getTransferFormat(format), 5121, null);
    }

    public void setImage(int level, int format, int width, int height, int depth, boolean border, int dformat, int dtype, ByteBuffer data) {
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
            height = GlUtil.nextPowerOfTwo(height);
            depth = GlUtil.nextPowerOfTwo(depth);
        }
        if (level == 0) {
            this._format = format;
            this._width = width;
            this._height = height;
            this._depth = depth;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        GL12.glTexImage3D((int)32879, (int)level, (int)format, (int)(width + ib2), (int)(height + ib2), (int)(depth + ib2), (int)ib, (int)dformat, (int)dtype, (ByteBuffer)data);
        this.setBytes(level, data == null ? width * height * depth * 4 : data.remaining());
    }

    public void setImages(int format, boolean border, BufferedImage image, int sdivs, int tdivs, int depth, boolean premultiply, boolean rescale, boolean mipmap) {
        this.setImage(0, format, border, image, sdivs, tdivs, depth, premultiply, rescale);
        if (mipmap) {
            int ww = this._width / 2;
            int hh = this._height / 2;
            int ll = 1;
            for (int dd = this._depth / 2; ww > 0 || hh > 0 || dd > 0; ww /= 2, hh /= 2, dd /= 2) {
                ++ll;
            }
        }
    }

    public void setImage(int level, int format, boolean border, BufferedImage image, int sdivs, int tdivs, int depth, boolean premultiply, boolean rescale) {
        int width = image.getWidth() / sdivs;
        int height = image.getHeight() / tdivs;
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
            height = GlUtil.nextPowerOfTwo(height);
            depth = GlUtil.nextPowerOfTwo(depth);
        }
        if (level == 0) {
            this._format = format;
            this._width = width;
            this._height = height;
            this._depth = depth;
        }
        this._renderer.setTexture(this);
        boolean ib = border;
    }

    public void copySubImage(int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        this._renderer.setTexture(this);
        GL12.glCopyTexSubImage3D((int)32879, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getDepth() {
        return this._depth;
    }
}

