/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.util.GlUtil;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.ARBTextureCompression;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class Texture2D
extends Texture {
    protected int _width;
    protected int _height;

    public Texture2D(Renderer renderer) {
        this(renderer, false);
    }

    public Texture2D(Renderer renderer, boolean rectangle) {
        super(renderer, rectangle ? 34037 : 3553);
        if (rectangle) {
            this._minFilter = 9729;
            this._wrapT = 33071;
            this._wrapS = 33071;
        }
    }

    public boolean isRectangle() {
        return this._target == 34037;
    }

    public void setImage(int format, int width, int height, boolean border, boolean mipmap) {
        this.setImage(0, format, width, height, border);
        if (mipmap && !this.isRectangle()) {
            int ww = this._width / 2;
            int ll = 1;
            for (int hh = this._height / 2; ww > 0 || hh > 0; ww /= 2, hh /= 2) {
                this.setImage(ll, format, Math.max(ww, 1), Math.max(hh, 1), border);
                ++ll;
            }
        }
    }

    public void setImage(int level, int format, int width, int height, boolean border) {
        this.setImage(level, format, width, height, border, Texture2D.getTransferFormat(format), 5121, null);
    }

    public void setImage(int level, int format, int width, int height, boolean border, int dformat, int dtype, ByteBuffer data) {
        if (!this.isRectangle() && !GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
            height = GlUtil.nextPowerOfTwo(height);
        }
        if (level == 0) {
            this._format = format;
            this._width = width;
            this._height = height;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        GL11.glTexImage2D((int)this._target, (int)level, (int)format, (int)(width + ib2), (int)(height + ib2), (int)ib, (int)dformat, (int)dtype, (ByteBuffer)data);
        this.setBytes(level, data == null ? width * height * 4 : data.remaining());
    }

    public void setCompressedImage(int level, int format, int width, int height, boolean border, ByteBuffer data) {
        if (level == 0) {
            this._format = format;
            this._width = width;
            this._height = height;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        ARBTextureCompression.glCompressedTexImage2DARB((int)this._target, (int)level, (int)format, (int)(width + ib2), (int)(height + ib2), (int)ib, (ByteBuffer)data);
        this.setBytes(level, data == null ? width * height * 4 : data.remaining());
    }

    public void setImage(int format, boolean border, BufferedImage image, boolean premultiply, boolean rescale, boolean mipmap) {
        if (!mipmap || this.isRectangle()) {
            this.setGenerateMipmaps(false);
            this.setImage(0, format, border, image, premultiply, rescale);
            return;
        }
        if (GLContext.getCapabilities().GL_SGIS_generate_mipmap) {
            this.setGenerateMipmaps(true);
            this.setImage(0, format, border, image, premultiply, rescale);
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (!this.isRectangle() && !GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
            height = GlUtil.nextPowerOfTwo(height);
        }
        this._format = format;
        this._width = width;
        this._height = height;
        this._renderer.setTexture(this);
        ByteBuffer data = Texture2D.getData(image, premultiply, width, height, rescale);
        GLU.gluBuild2DMipmaps((int)this._target, (int)format, (int)width, (int)height, (int)Texture2D.getFormat(image), (int)5121, (ByteBuffer)data);
        this.setMipmapBytes(data.remaining(), width, height);
    }

    public void setImage(int level, int format, boolean border, BufferedImage image, boolean premultiply, boolean rescale) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (!this.isRectangle() && !GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
            height = GlUtil.nextPowerOfTwo(height);
        }
        if (level == 0) {
            this._format = format;
            this._width = width;
            this._height = height;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        ByteBuffer data = Texture2D.getData(image, premultiply, width, height, rescale);
        GL11.glTexImage2D((int)this._target, (int)level, (int)format, (int)(width + ib2), (int)(height + ib2), (int)ib, (int)Texture2D.getFormat(image), (int)5121, (ByteBuffer)data);
        if (level == 0 && this._generateMipmaps) {
            this.setMipmapBytes(data.remaining(), width, height);
        } else {
            this.setBytes(level, data.remaining());
        }
    }

    public void setImage(BufferedImage image, boolean premultiply, boolean mipmap, boolean compress) {
        this.setImage(image, premultiply, mipmap, compress, true);
    }

    public void setImage(BufferedImage image, boolean premultiply, boolean mipmap, boolean compress, boolean rescale) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (!this.isRectangle() && !GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
            height = GlUtil.nextPowerOfTwo(height);
        }
        this._renderer.setTexture(this);
        ByteBuffer data = Texture2D.getData(image, premultiply, width, height, rescale);
        if (mipmap && !this.isRectangle()) {
            if (GLContext.getCapabilities().GL_SGIS_generate_mipmap) {
                this.setGenerateMipmaps(true);
                this._width = width;
                this._height = height;
                this._format = Texture2D.getFormat(image);
                GL11.glTexImage2D((int)this._target, (int)0, (int)Texture2D.getInternalFormat(image, compress), (int)this._width, (int)this._height, (int)0, (int)this._format, (int)5121, (ByteBuffer)data);
            } else {
                this._width = width;
                this._height = height;
                this._format = Texture2D.getFormat(image);
                GLU.gluBuild2DMipmaps((int)this._target, (int)Texture2D.getInternalFormat(image, compress), (int)this._width, (int)this._height, (int)this._format, (int)5121, (ByteBuffer)data);
            }
            this.setMipmapBytes(data.remaining(), width, height);
        } else {
            this.setGenerateMipmaps(false);
            this._width = width;
            this._height = height;
            this._format = Texture2D.getFormat(image);
            GL11.glTexImage2D((int)this._target, (int)0, (int)Texture2D.getInternalFormat(image, compress), (int)this._width, (int)this._height, (int)0, (int)this._format, (int)5121, (ByteBuffer)data);
            this.setBytes(0, data.remaining());
        }
    }

    public void setSubimage(BufferedImage image, boolean premultiply, int x, int y, int width, int height) {
        this.setSubimage(0, x, y, width, height, Texture2D.getFormat(image), 5121, Texture2D.getData(image, premultiply, width, height, true));
    }

    public void setSubimage(int level, int x, int y, int width, int height, int dformat, int dtype, ByteBuffer data) {
        this._renderer.setTexture(this);
        GL11.glTexSubImage2D((int)this._target, (int)level, (int)x, (int)y, (int)width, (int)height, (int)dformat, (int)dtype, (ByteBuffer)data);
    }

    public void copySubImage(int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this._renderer.setTexture(this);
        GL11.glCopyTexSubImage2D((int)this._target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }
}

