/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.util.GlUtil;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class Texture1D
extends Texture {
    protected int _width;

    public Texture1D(Renderer renderer) {
        super(renderer, 3552);
    }

    public void setImage(int format, int width, boolean border, boolean mipmap) {
        this.setImage(0, format, width, border);
        if (mipmap) {
            int ll = 1;
            for (int ww = this._width / 2; ww > 0; ww /= 2) {
                this.setImage(ll, format, ww, border);
                ++ll;
            }
        }
    }

    public void setImage(int level, int format, int width, boolean border) {
        this.setImage(level, format, width, border, Texture1D.getTransferFormat(format), 5121, null);
    }

    public void setImage(int level, int format, int width, boolean border, int dformat, int dtype, ByteBuffer data) {
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
        }
        if (level == 0) {
            this._format = format;
            this._width = width;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        GL11.glTexImage1D((int)3552, (int)level, (int)format, (int)(width + ib2), (int)ib, (int)dformat, (int)dtype, (ByteBuffer)data);
        this.setBytes(level, data == null ? width * 4 : data.remaining());
    }

    public void setImage(int format, boolean border, BufferedImage image, boolean premultiply, boolean rescale, boolean mipmap) {
        this.setImage(0, format, border, image, premultiply, rescale);
        if (mipmap) {
            int ll = 1;
            for (int ww = this._width / 2; ww > 0; ww /= 2) {
                image = Texture1D.halveImage(image);
                this.setImage(ll, format, border, image, premultiply, rescale);
                ++ll;
            }
        }
    }

    public void setImage(int level, int format, boolean border, BufferedImage image, boolean premultiply, boolean rescale) {
        int width = image.getWidth();
        if (!GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            width = GlUtil.nextPowerOfTwo(width);
        }
        if (level == 0) {
            this._format = format;
            this._width = width;
        }
        this._renderer.setTexture(this);
        int ib = border ? 1 : 0;
        int ib2 = ib * 2;
        ByteBuffer data = Texture1D.getData(image, premultiply, width, 1, rescale);
        GL11.glTexImage1D((int)3552, (int)level, (int)format, (int)(width + ib2), (int)ib, (int)Texture1D.getFormat(image), (int)5121, (ByteBuffer)data);
        this.setBytes(level, data.remaining());
    }

    public void copySubImage(int level, int xoffset, int x, int y, int width) {
        this._renderer.setTexture(this);
        GL11.glCopyTexSubImage1D((int)3552, (int)level, (int)xoffset, (int)x, (int)y, (int)width);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return 1;
    }
}

