/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.samskivert.util.HashIntMap;
import com.threerings.math.Matrix4f;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.math.Vector4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Shader;
import com.threerings.opengl.renderer.ShaderObject;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;

public class Program
extends ShaderObject {
    protected Shader _vertex;
    protected Shader _fragment;
    protected HashMap<String, Integer> _uniformLocations = new HashMap();
    protected HashMap<String, Integer> _attribLocations = new HashMap();
    protected HashIntMap<Uniform> _uniforms = new HashIntMap();
    protected static FloatBuffer _vbuf = BufferUtils.createFloatBuffer((int)16);

    public Program(Renderer renderer) {
        super(renderer);
        this._id = ARBShaderObjects.glCreateProgramObjectARB();
        this._renderer.shaderObjectCreated();
    }

    public boolean relink() {
        return this.setShaders(this._vertex, this._fragment);
    }

    public boolean setShaders(Shader vertex, Shader fragment) {
        if (this._vertex != vertex) {
            if (this._vertex != null) {
                ARBShaderObjects.glDetachObjectARB((int)this._id, (int)this._vertex.getId());
            }
            if ((this._vertex = vertex) != null) {
                ARBShaderObjects.glAttachObjectARB((int)this._id, (int)this._vertex.getId());
            }
        }
        if (this._fragment != fragment) {
            if (this._fragment != null) {
                ARBShaderObjects.glDetachObjectARB((int)this._id, (int)this._fragment.getId());
            }
            if ((this._fragment = fragment) != null) {
                ARBShaderObjects.glAttachObjectARB((int)this._id, (int)this._fragment.getId());
            }
        }
        ARBShaderObjects.glLinkProgramARB((int)this._id);
        IntBuffer ibuf = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)this._id, (int)35714, (IntBuffer)ibuf);
        return ibuf.get(0) == 1;
    }

    public Shader getVertexShader() {
        return this._vertex;
    }

    public Shader getFragmentShader() {
        return this._fragment;
    }

    public int getUniformLocation(String name) {
        Integer location = this._uniformLocations.get(name);
        if (location == null) {
            location = ARBShaderObjects.glGetUniformLocationARB((int)this._id, (ByteBuffer)Program.toBuffer(name));
            this._uniformLocations.put(name, location);
        }
        return location;
    }

    public void setUniforms(Uniform[] uniforms) {
        for (Uniform uniform : uniforms) {
            int location = uniform.getLocation();
            Uniform uval = (Uniform)this._uniforms.get(location);
            if (uval == uniform && !uniform.dirty) continue;
            uniform.dirty = false;
            if (uniform.equals(uval)) continue;
            uniform.apply();
            Uniform nval = uniform.clone(uval);
            if (nval == uval) continue;
            this._uniforms.put(location, (Object)nval);
        }
    }

    public void setAttribLocation(String name, int index) {
        ARBVertexShader.glBindAttribLocationARB((int)this._id, (int)index, (ByteBuffer)Program.toBuffer(name));
        this._attribLocations.put(name, index);
    }

    public int getAttribLocation(String name) {
        Integer location = this._attribLocations.get(name);
        if (location == null) {
            location = ARBVertexShader.glGetAttribLocationARB((int)this._id, (ByteBuffer)Program.toBuffer(name));
            this._attribLocations.put(name, location);
        }
        return location;
    }

    protected Program() {
        super(null);
    }

    protected static ByteBuffer toBuffer(String string) {
        ByteBuffer buf = ASCII_CHARSET.encode(string);
        ByteBuffer buf0 = BufferUtils.createByteBuffer((int)(buf.remaining() + 1));
        buf0.put(buf).put((byte)0).rewind();
        return buf0;
    }

    public static class Matrix4fUniform
    extends Uniform {
        public Matrix4f value = new Matrix4f();

        public Matrix4fUniform(int location) {
            super(location);
        }

        public Matrix4fUniform(int location, Matrix4f value) {
            super(location);
            this.value.set(value);
        }

        public void apply() {
            this.value.get(_vbuf).rewind();
            ARBShaderObjects.glUniformMatrix4ARB((int)this._location, (boolean)false, (FloatBuffer)_vbuf);
        }

        public Uniform clone(Uniform uniform) {
            Matrix4fUniform clone = uniform instanceof Matrix4fUniform ? (Matrix4fUniform)uniform : new Matrix4fUniform(this._location);
            clone.value.set(this.value);
            return clone;
        }

        public boolean equals(Object other) {
            return other instanceof Matrix4fUniform && ((Matrix4fUniform)other).value.equals(this.value);
        }
    }

    public static class Vector4fUniform
    extends Uniform {
        public Vector4f value = new Vector4f();

        public Vector4fUniform(int location) {
            super(location);
        }

        public Vector4fUniform(int location, Vector4f value) {
            super(location);
            this.value.set(value);
        }

        public void apply() {
            ARBShaderObjects.glUniform4fARB((int)this._location, (float)this.value.x, (float)this.value.y, (float)this.value.z, (float)this.value.w);
        }

        public Uniform clone(Uniform uniform) {
            Vector4fUniform clone = uniform instanceof Vector4fUniform ? (Vector4fUniform)uniform : new Vector4fUniform(this._location);
            clone.value.set(this.value);
            return clone;
        }

        public boolean equals(Object other) {
            return other instanceof Vector4fUniform && ((Vector4fUniform)other).value.equals(this.value);
        }
    }

    public static class Vector3fUniform
    extends Uniform {
        public Vector3f value = new Vector3f();

        public Vector3fUniform(int location) {
            super(location);
        }

        public Vector3fUniform(int location, Vector3f value) {
            super(location);
            this.value.set(value);
        }

        public void apply() {
            ARBShaderObjects.glUniform3fARB((int)this._location, (float)this.value.x, (float)this.value.y, (float)this.value.z);
        }

        public Uniform clone(Uniform uniform) {
            Vector3fUniform clone = uniform instanceof Vector3fUniform ? (Vector3fUniform)uniform : new Vector3fUniform(this._location);
            clone.value.set(this.value);
            return clone;
        }

        public boolean equals(Object other) {
            return other instanceof Vector3fUniform && ((Vector3fUniform)other).value.equals(this.value);
        }
    }

    public static class Vector2fUniform
    extends Uniform {
        public Vector2f value = new Vector2f();

        public Vector2fUniform(int location) {
            super(location);
        }

        public Vector2fUniform(int location, Vector2f value) {
            super(location);
            this.value.set(value);
        }

        public void apply() {
            ARBShaderObjects.glUniform2fARB((int)this._location, (float)this.value.x, (float)this.value.y);
        }

        public Uniform clone(Uniform uniform) {
            Vector2fUniform clone = uniform instanceof Vector2fUniform ? (Vector2fUniform)uniform : new Vector2fUniform(this._location);
            clone.value.set(this.value);
            return clone;
        }

        public boolean equals(Object other) {
            return other instanceof Vector2fUniform && ((Vector2fUniform)other).value.equals(this.value);
        }
    }

    public static class FloatUniform
    extends Uniform {
        public float value;

        public FloatUniform(int location) {
            super(location);
        }

        public FloatUniform(int location, float value) {
            super(location);
            this.value = value;
        }

        public void apply() {
            ARBShaderObjects.glUniform1fARB((int)this._location, (float)this.value);
        }

        public Uniform clone(Uniform uniform) {
            FloatUniform clone = uniform instanceof FloatUniform ? (FloatUniform)uniform : new FloatUniform(this._location);
            clone.value = this.value;
            return clone;
        }

        public boolean equals(Object other) {
            return other instanceof FloatUniform && ((FloatUniform)other).value == this.value;
        }
    }

    public static class IntegerUniform
    extends Uniform {
        public int value;

        public IntegerUniform(int location) {
            super(location);
        }

        public IntegerUniform(int location, int value) {
            super(location);
            this.value = value;
        }

        public void apply() {
            ARBShaderObjects.glUniform1iARB((int)this._location, (int)this.value);
        }

        public Uniform clone(Uniform uniform) {
            IntegerUniform clone = uniform instanceof IntegerUniform ? (IntegerUniform)uniform : new IntegerUniform(this._location);
            clone.value = this.value;
            return clone;
        }

        public boolean equals(Object other) {
            return other instanceof IntegerUniform && ((IntegerUniform)other).value == this.value;
        }
    }

    public static abstract class Uniform {
        public boolean dirty;
        protected int _location;

        public Uniform(int location) {
            this._location = location;
        }

        public int getLocation() {
            return this._location;
        }

        public abstract void apply();

        public abstract Uniform clone(Uniform var1);
    }
}

