/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class Color4f
implements Encodable,
Streamable {
    public static final Color4f WHITE = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color4f GRAY = new Color4f(0.8f, 0.8f, 0.8f, 1.0f);
    public static final Color4f DARK_GRAY = new Color4f(0.2f, 0.2f, 0.2f, 1.0f);
    public static final Color4f BLACK = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color4f TRANSPARENT_BLACK = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color4f RED = new Color4f(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color4f GREEN = new Color4f(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color4f BLUE = new Color4f(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color4f CYAN = new Color4f(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color4f MAGENTA = new Color4f(1.0f, 0.0f, 1.0f, 1.0f);
    public static final Color4f YELLOW = new Color4f(1.0f, 1.0f, 0.0f, 1.0f);
    public float r;
    public float g;
    public float b;
    public float a;

    public Color4f(float r, float g, float b, float a) {
        this.set(r, g, b, a);
    }

    public Color4f(float[] values) {
        this.set(values);
    }

    public Color4f(Color4f other) {
        this.set(other);
    }

    public Color4f(Color color) {
        this.set(color);
    }

    public Color4f() {
        this.set(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Color getColor() {
        return this.getColor(true);
    }

    public Color getColor(boolean includeAlpha) {
        return new Color(this.r, this.g, this.b, includeAlpha ? this.a : 1.0f);
    }

    public Color4f multLocal(float value) {
        return this.mult(value, this);
    }

    public Color4f mult(float value) {
        return this.mult(value, new Color4f());
    }

    public Color4f mult(float value, Color4f result) {
        return result.set(this.r * value, this.g * value, this.b * value, this.a * value);
    }

    public Color4f multLocal(Color4f other) {
        return this.mult(other, this);
    }

    public Color4f mult(Color4f other) {
        return this.mult(other, new Color4f());
    }

    public Color4f mult(Color4f other, Color4f result) {
        return result.set(this.r * other.r, this.g * other.g, this.b * other.b, this.a * other.a);
    }

    public Color4f addLocal(Color4f other) {
        return this.add(other, this);
    }

    public Color4f add(Color4f other) {
        return this.add(other, new Color4f());
    }

    public Color4f add(Color4f other, Color4f result) {
        return result.set(this.r + other.r, this.g + other.g, this.b + other.b, this.a + other.a);
    }

    public Color4f clampedAddLocal(Color4f other) {
        return this.clampedAdd(other, this);
    }

    public Color4f clampedAdd(Color4f other) {
        return this.clampedAdd(other, new Color4f());
    }

    public Color4f clampedAdd(Color4f other, Color4f result) {
        return result.set(Math.min(this.r + other.r, 1.0f), Math.min(this.g + other.g, 1.0f), Math.min(this.b + other.b, 1.0f), Math.min(this.a + other.a, 1.0f));
    }

    public Color4f lerpLocal(Color4f other, float t) {
        return this.lerp(other, t, this);
    }

    public Color4f lerp(Color4f other, float t) {
        return this.lerp(other, t, new Color4f());
    }

    public Color4f lerp(Color4f other, float t, Color4f result) {
        return result.set(this.r + t * (other.r - this.r), this.g + t * (other.g - this.g), this.b + t * (other.b - this.b), this.a + t * (other.a - this.a));
    }

    public Color4f set(Color4f other) {
        return this.set(other.r, other.g, other.b, other.a);
    }

    public Color4f set(Color color) {
        return this.set(color.getRGBComponents(null));
    }

    public Color4f set(float[] values) {
        return this.set(values[0], values[1], values[2], values[3]);
    }

    public Color4f set(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public FloatBuffer get(FloatBuffer buf) {
        return buf.put(this.r).put(this.g).put(this.b).put(this.a);
    }

    public String encodeToString() {
        return this.r + ", " + this.g + ", " + this.b + ", " + this.a;
    }

    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.r);
        out.writeFloat(this.g);
        out.writeFloat(this.b);
        out.writeFloat(this.a);
    }

    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[" + this.r + ", " + this.g + ", " + this.b + ", " + this.a + "]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.r) ^ Float.floatToIntBits(this.g) ^ Float.floatToIntBits(this.b) ^ Float.floatToIntBits(this.a);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Color4f)) {
            return false;
        }
        Color4f ocolor = (Color4f)other;
        return this.r == ocolor.r && this.g == ocolor.g && this.b == ocolor.b && this.a == ocolor.a;
    }
}

