/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.tools;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.math.Transform3D;
import com.threerings.opengl.GlCanvasTool;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.SimpleScene;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.util.DeepObject;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;

public abstract class ModelTool
extends GlCanvasTool {
    protected JCheckBoxMenuItem _showEnvironment;
    protected SimpleScene _scene;
    protected Model[] _environment;
    protected Model _model;

    public ModelTool(String msgs) {
        super(msgs);
    }

    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("environment")) {
            ((ModelToolPrefs)this._eprefs).updateEnvironment();
        } else if (action.equals("reset")) {
            this._model.reset();
        } else {
            super.actionPerformed(event);
        }
    }

    protected void didInit() {
        super.didInit();
        ((OrbitCameraHandler)this._camhand).setCoordLimits(-1.5707964f, 1.5707964f, 2.0f, 50.0f);
        this._scene = new SimpleScene(this);
        this._scene.setParentScope(this);
        ((ModelToolPrefs)this._eprefs).updateEnvironment();
    }

    protected DebugBounds createBounds() {
        return new DebugBounds(this){

            protected void draw() {
                ModelTool.this._model.drawBounds();
            }
        };
    }

    protected void updateView(float elapsed) {
        super.updateView(elapsed);
        this._scene.tick(elapsed);
    }

    protected void compositeView() {
        super.compositeView();
        this._scene.composite();
    }

    protected class ModelToolPrefs
    extends GlCanvasTool.CanvasToolPrefs {
        protected EnvironmentModel[] _environmentModels;

        public ModelToolPrefs(Preferences prefs) {
            super(prefs);
            this._environmentModels = (EnvironmentModel[])this.getPref("environment_models", new EnvironmentModel[0]);
        }

        @Editable(weight=8.0)
        public void setEnvironmentModels(EnvironmentModel[] models) {
            this._environmentModels = models;
            this.putPref("environment_models", models);
            this.updateEnvironment();
        }

        @Editable
        public EnvironmentModel[] getEnvironmentModels() {
            return this._environmentModels;
        }

        public void updateEnvironment() {
            int ii;
            Model[] omodels = ModelTool.this._environment;
            ModelTool.this._environment = new Model[ModelTool.this._showEnvironment.isSelected() ? this._environmentModels.length : 0];
            for (ii = 0; ii < ModelTool.this._environment.length; ++ii) {
                Model model;
                EnvironmentModel envmod = this._environmentModels[ii];
                Model model2 = model = omodels == null || omodels.length <= ii ? null : omodels[ii];
                if (model == null) {
                    model = new Model(ModelTool.this);
                    ModelTool.this._scene.add(model);
                }
                model.setConfig(envmod.model);
                ModelTool.this._environment[ii] = model;
                model.setLocalTransform(envmod.transform);
            }
            if (omodels != null) {
                for (ii = ModelTool.this._environment.length; ii < omodels.length; ++ii) {
                    ModelTool.this._scene.remove(omodels[ii]);
                    omodels[ii].dispose();
                }
            }
        }
    }

    public static class EnvironmentModel
    extends DeepObject
    implements Exportable {
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();
    }
}

