/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.tools;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.QuickSort;
import com.samskivert.util.StringUtil;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.Log;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.config.ArticulatedConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.config.StaticConfig;
import com.threerings.opengl.model.config.StaticSetConfig;
import com.threerings.opengl.renderer.config.ClientArrayConfig;
import com.threerings.util.ArrayKey;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.lwjgl.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelDef {
    public HashMap<String, SpatialDef> spatials = new HashMap();
    protected static final int MAX_BONE_COUNT = 31;

    public static Transform3D createTransform(float[] translation, float[] rotation, float[] scale, float gscale) {
        Vector3f trans = new Vector3f(translation).multLocal(gscale);
        Quaternion rot = new Quaternion(rotation);
        if (scale[0] != scale[1] || scale[1] != scale[2]) {
            return new Transform3D(trans, rot, new Vector3f(scale));
        }
        if (scale[0] != 1.0f) {
            return new Transform3D(trans, rot, scale[0]);
        }
        if (!trans.equals(Vector3f.ZERO) || !rot.equals(Quaternion.IDENTITY)) {
            return new Transform3D(trans, rot);
        }
        return new Transform3D();
    }

    public void addSpatial(SpatialDef spatial) {
        this.spatials.put(spatial.name, spatial);
    }

    public void update(StaticConfig config) {
        config.meshes = this.createRootNode().createMeshes(config);
    }

    public void update(StaticSetConfig config) {
        ArrayList<SpatialDef> tops = this.resolveReferences();
        config.meshes = new TreeMap();
        for (SpatialDef top : tops) {
            ModelConfig.MeshSet meshes = top.createMeshes(config);
            if (meshes == null) continue;
            config.meshes.put(top.name, meshes);
        }
    }

    public void update(ArticulatedConfig config) {
        this.createRootNode().update(config);
    }

    protected NodeDef createRootNode() {
        ArrayList<SpatialDef> tops = this.resolveReferences();
        NodeDef node = new NodeDef();
        node.name = "%ROOT%";
        node.childDefs = tops;
        for (SpatialDef top : tops) {
            top.parentDef = node;
        }
        return node;
    }

    protected ArrayList<SpatialDef> resolveReferences() {
        ArrayList<SpatialDef> tops = new ArrayList<SpatialDef>();
        for (SpatialDef spatial : this.spatials.values()) {
            if (spatial.parent == null) {
                tops.add(spatial);
                continue;
            }
            spatial.parentDef = this.spatials.get(spatial.parent);
            if (spatial.parentDef != null) {
                spatial.parentDef.childDefs.add(spatial);
                continue;
            }
            Log.log.warning((Object)("Missing parent node [node=" + spatial.name + ", parent=" + spatial.parent + "]."), new Object[0]);
            tops.add(spatial);
        }
        return tops;
    }

    protected static Matrix4f createMatrix(float[] translation, float[] rotation, float[] scale) {
        return ModelDef.createMatrix(translation, rotation, scale, 1.0f);
    }

    protected static Matrix4f createMatrix(float[] translation, float[] rotation, float[] scale, float gscale) {
        Matrix4f matrix = new Matrix4f();
        return matrix.setToTransform(new Vector3f(translation).multLocal(gscale), new Quaternion(rotation), new Vector3f(scale).multLocal(gscale));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HashArrayList<E>
    extends ArrayList<E> {
        protected HashMap<Object, Integer> _indices = new HashMap();

        protected HashArrayList() {
        }

        @Override
        public boolean add(E element) {
            this.add(this.size(), element);
            return true;
        }

        @Override
        public void add(int idx, E element) {
            super.add(idx, element);
            this.remapFrom(idx);
        }

        @Override
        public E remove(int idx) {
            Object element = super.remove(idx);
            this._indices.remove(element);
            this.remapFrom(idx);
            return element;
        }

        @Override
        public void clear() {
            super.clear();
            this._indices.clear();
        }

        @Override
        public int indexOf(Object obj) {
            Integer idx = this._indices.get(obj);
            return idx == null ? -1 : idx;
        }

        @Override
        public boolean contains(Object obj) {
            return this._indices.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            Integer idx = this._indices.remove(obj);
            if (idx != null) {
                super.remove(idx);
                return true;
            }
            return false;
        }

        protected void remapFrom(int idx) {
            int nn = this.size();
            for (int ii = idx; ii < nn; ++ii) {
                this._indices.put(this.get(ii), ii);
            }
        }
    }

    protected static class Triangle {
        public Vertex[] vertices;

        public Triangle(Vertex[] vertices) {
            this.vertices = vertices;
        }

        public float getScore() {
            return this.vertices[0].score + this.vertices[1].score + this.vertices[2].score;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoneWeight
    implements Comparable<BoneWeight> {
        public String bone;
        public float weight;

        @Override
        public int compareTo(BoneWeight other) {
            return Float.compare(this.weight, other.weight);
        }

        public boolean equals(Object other) {
            return this.weight == ((BoneWeight)other).weight;
        }

        public String toString() {
            return this.bone + " " + this.weight;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SkinVertex
    extends Vertex {
        public HashMap<String, BoneWeight> boneWeights = new HashMap();

        public void addBoneWeight(BoneWeight weight) {
            if (weight.weight == 0.0f) {
                return;
            }
            BoneWeight bweight = this.boneWeights.get(weight.bone);
            if (bweight != null) {
                bweight.weight += weight.weight;
            } else {
                this.boneWeights.put(weight.bone, weight);
            }
        }

        public Set<String> getBones() {
            if (this.boneWeights.size() > 4) {
                Comparable[] weights = this.boneWeights.values().toArray(new BoneWeight[this.boneWeights.size()]);
                QuickSort.rsort((Comparable[])weights);
                float ototal = this.getTotalWeight();
                for (int ii = 4; ii < weights.length; ++ii) {
                    this.boneWeights.remove(((BoneWeight)weights[ii]).bone);
                }
                float scale = ototal / this.getTotalWeight();
                for (BoneWeight weight : this.boneWeights.values()) {
                    weight.weight *= scale;
                }
            }
            return this.boneWeights.keySet();
        }

        public void get(FloatBuffer vbuf, String[] bones) {
            int ii;
            Comparable[] weights = this.boneWeights.values().toArray(new BoneWeight[this.boneWeights.size()]);
            QuickSort.rsort((Comparable[])weights);
            for (ii = 0; ii < 4; ++ii) {
                vbuf.put(ii < weights.length ? (float)ListUtil.indexOf((Object[])bones, (Object)((BoneWeight)weights[ii]).bone) : 0.0f);
            }
            for (ii = 0; ii < 4; ++ii) {
                vbuf.put(ii < weights.length ? ((BoneWeight)weights[ii]).weight : 0.0f);
            }
            super.get(vbuf);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.boneWeights.equals(((SkinVertex)obj).boneWeights);
        }

        protected float getTotalWeight() {
            float total = 0.0f;
            for (BoneWeight weight : this.boneWeights.values()) {
                total += weight.weight;
            }
            return total;
        }
    }

    public static class Extra {
        public float[] tcoords;

        public boolean equals(Object other) {
            return Arrays.equals(this.tcoords, ((Extra)other).tcoords);
        }
    }

    public static class Vertex {
        public float[] location;
        public float[] normal;
        public float[] tcoords;
        public float[] color;
        public List<Extra> extras = Lists.newArrayList();
        public ArrayList<Triangle> triangles;
        public float score;
        public Vector3f tangent;

        public void addExtra(Extra extra) {
            this.extras.add(extra);
        }

        public void transform(Matrix4f vtrans, Matrix4f ntrans) {
            vtrans.transformPointLocal(new Vector3f(this.location)).get(this.location);
            ntrans.transformVectorLocal(new Vector3f(this.normal)).normalizeLocal().get(this.normal);
        }

        public void generateTangent() {
            this.tangent = new Vector3f();
            Vector3f normal = new Vector3f(this.normal);
            Vector3f vec = new Vector3f();
            Quaternion rot = new Quaternion();
            for (Triangle triangle : this.triangles) {
                for (Vertex vertex : triangle.vertices) {
                    if (vertex == this) continue;
                    vec.set(vertex.location[0] - this.location[0], vertex.location[1] - this.location[1], vertex.location[2] - this.location[2]).crossLocal(normal);
                    if (vec.length() < 1.0E-6f) continue;
                    float angle = FloatMath.atan2(vertex.tcoords[0] - this.tcoords[0], vertex.tcoords[1] - this.tcoords[1]);
                    rot.fromAngleAxis(angle, normal).transformLocal(vec).normalizeLocal();
                    this.tangent.addLocal(vec);
                }
            }
            if (this.tangent.length() > 0.0f) {
                this.tangent.normalizeLocal();
            }
        }

        public void get(FloatBuffer vbuf) {
            if (this.tangent != null) {
                this.tangent.get(vbuf);
            }
            vbuf.put(this.tcoords);
            int nn = this.extras.size();
            for (int ii = 0; ii < nn; ++ii) {
                vbuf.put(this.extras.get((int)ii).tcoords);
            }
            if (this.color != null) {
                vbuf.put(this.color);
            }
            vbuf.put(this.normal);
            vbuf.put(this.location);
        }

        public void updateScore(int cacheIdx) {
            float pscore = cacheIdx > 63 ? 0.0f : (cacheIdx < 3 ? 0.75f : FloatMath.pow((float)(63 - cacheIdx) / 60.0f, 1.5f));
            this.score = pscore + 2.0f * FloatMath.pow(this.triangles.size(), -0.5f);
        }

        public int hashCode() {
            return Arrays.hashCode(this.location) ^ Arrays.hashCode(this.normal) ^ Arrays.hashCode(this.tcoords) ^ Arrays.hashCode(this.color);
        }

        public boolean equals(Object obj) {
            Vertex overt = (Vertex)obj;
            return Arrays.equals(this.location, overt.location) && Arrays.equals(this.normal, overt.normal) && Arrays.equals(this.tcoords, overt.tcoords) && Arrays.equals(this.color, overt.color) && ((Object)this.extras).equals(overt.extras);
        }

        public String toString() {
            return StringUtil.toString((Object)this.location);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SkinMeshDef
    extends TriMeshDef {
        public HashSet<String> mbones = new HashSet();

        public SkinMeshDef() {
        }

        public SkinMeshDef(SkinMeshDef other) {
            this.texture = other.texture;
            this.tag = other.tag;
            this.colored = other.colored;
        }

        @Override
        public void addVertex(Vertex vertex) {
            super.addVertex(vertex);
            this.mbones.addAll(((SkinVertex)vertex).getBones());
        }

        @Override
        public void mergeSkinMeshes(HashMap<Object, SkinMeshDef> meshes, HashSet<String> bones) {
            Matrix4f vtrans = this.getTransformMatrix().mult(ModelDef.createMatrix(this.offsetTranslation, this.offsetRotation, this.offsetScale));
            this.transformVertices(vtrans);
            Object key = this.getConfigurationKey();
            SkinMeshDef omesh = meshes.get(key);
            if (omesh == null) {
                meshes.put(key, this);
            } else {
                omesh.merge(this);
            }
            bones.addAll(this.mbones);
            super.mergeSkinMeshes(meshes, bones);
        }

        @Override
        public void removeBoneWeights(String bone) {
            super.removeBoneWeights(bone);
            for (Vertex vertex : this.vertices) {
                ((SkinVertex)vertex).boneWeights.remove(bone);
            }
        }

        @Override
        public void mergeSkinMeshes(TriMeshDef mesh) {
            mesh.merge(this);
            super.mergeSkinMeshes(mesh);
        }

        @Override
        public ArticulatedConfig.Node createNode(ArticulatedConfig config, boolean haveCollisionMesh) {
            return new ArticulatedConfig.Node(this.name, ModelDef.createTransform(this.translation, this.rotation, this.scale, config.scale), this.createChildNodes(config, haveCollisionMesh));
        }

        public void createSkinMeshes(ArticulatedConfig config, ArrayList<ModelConfig.VisibleMesh> meshes) {
            SkinMeshDef mesh = new SkinMeshDef(this);
            int nn = this.indices.size();
            for (int ii = 0; ii < nn; ii += 3) {
                SkinVertex s1 = (SkinVertex)this.vertices.get((Integer)this.indices.get(ii));
                SkinVertex s2 = (SkinVertex)this.vertices.get((Integer)this.indices.get(ii + 1));
                SkinVertex s3 = (SkinVertex)this.vertices.get((Integer)this.indices.get(ii + 2));
                HashSet<String> tbones = new HashSet<String>();
                tbones.addAll(s1.getBones());
                tbones.addAll(s2.getBones());
                tbones.addAll(s3.getBones());
                HashSet<String> nbones = new HashSet<String>(mesh.mbones);
                nbones.addAll(tbones);
                if (nbones.size() > 31) {
                    meshes.add(mesh.createVisibleMesh(config));
                    mesh = new SkinMeshDef(this);
                }
                mesh.addVertex(s1);
                mesh.addVertex(s2);
                mesh.addVertex(s3);
            }
            if (!mesh.indices.isEmpty()) {
                meshes.add(mesh.createVisibleMesh(config));
            }
        }

        @Override
        protected GeometryConfig.AttributeArrayConfig[] createVertexAttribArrays(ModelConfig.Imported config) {
            Object[] arrays = new GeometryConfig.AttributeArrayConfig[]{new GeometryConfig.AttributeArrayConfig(4, "boneIndices"), new GeometryConfig.AttributeArrayConfig(4, "boneWeights")};
            Object[] sarrays = super.createVertexAttribArrays(config);
            return sarrays == null ? arrays : (GeometryConfig.AttributeArrayConfig[])ArrayUtil.concatenate((Object[])arrays, (Object[])sarrays);
        }

        @Override
        protected String getDefaultTag() {
            return "skinned";
        }

        @Override
        protected GeometryConfig createGeometry(Box bounds, GeometryConfig.AttributeArrayConfig[] vertexAttribArrays, ClientArrayConfig[] texCoordArrays, ClientArrayConfig colorArray, ClientArrayConfig normalArray, ClientArrayConfig vertexArray) {
            String[] bones = this.mbones.toArray(new String[this.mbones.size()]);
            FloatBuffer vbuf = vertexArray.floatArray;
            for (Vertex vertex : this.vertices) {
                ((SkinVertex)vertex).get(vbuf, bones);
            }
            vbuf.rewind();
            return new GeometryConfig.SkinnedIndexedStored(bounds, GeometryConfig.Mode.TRIANGLES, vertexAttribArrays, texCoordArrays, colorArray, normalArray, vertexArray, 0, this.vertices.size() - 1, this.createIndexBuffer(), bones);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TriMeshDef
    extends SpatialDef {
        public float[] offsetTranslation;
        public float[] offsetRotation;
        public float[] offsetScale;
        public String texture = "";
        public String tag;
        public HashArrayList<Vertex> vertices = new HashArrayList();
        public ArrayList<Integer> indices = new ArrayList();
        public boolean colored;

        public void addVertex(Vertex vertex) {
            int idx = this.vertices.indexOf(vertex);
            if (idx != -1) {
                this.indices.add(idx);
            } else {
                this.indices.add(this.vertices.size());
                this.vertices.add(vertex);
                float[] color = vertex.color;
                this.colored |= color != null && (color[0] != 1.0f || color[1] != 1.0f || color[2] != 1.0f || color[3] != 1.0f);
            }
        }

        @Override
        public ArticulatedConfig.Node createNode(ArticulatedConfig config, boolean haveCollisionMesh) {
            this.transformVertices(ModelDef.createMatrix(this.offsetTranslation, this.offsetRotation, this.offsetScale, config.scale));
            boolean isCollisionMesh = this.name.contains("collision");
            return new ArticulatedConfig.MeshNode(this.name, ModelDef.createTransform(this.translation, this.rotation, this.scale, config.scale), this.createChildNodes(config, haveCollisionMesh), isCollisionMesh ? null : this.createVisibleMesh(config), (CollisionMesh)(haveCollisionMesh && !isCollisionMesh ? null : this.createCollisionMesh()));
        }

        @Override
        public void mergeMeshes(HashMap<Object, TriMeshDef> meshes) {
            Matrix4f vtrans = this.getTransformMatrix().mult(ModelDef.createMatrix(this.offsetTranslation, this.offsetRotation, this.offsetScale));
            this.transformVertices(vtrans);
            Object key = this.getConfigurationKey();
            TriMeshDef omesh = meshes.get(key);
            if (omesh == null) {
                meshes.put(key, this);
            } else {
                omesh.merge(this);
            }
            super.mergeMeshes(meshes);
        }

        @Override
        public void mergeMeshes(TriMeshDef mesh) {
            mesh.merge(this);
            super.mergeMeshes(mesh);
        }

        public Object getConfigurationKey() {
            if (this.name.contains("collision")) {
                return "collision";
            }
            return new ArrayKey(this.getClass(), this.texture, this.tag);
        }

        public void merge(TriMeshDef omesh) {
            for (int idx : omesh.indices) {
                this.addVertex((Vertex)omesh.vertices.get(idx));
            }
        }

        public ModelConfig.VisibleMesh createVisibleMesh(ModelConfig.Imported config) {
            if (!this.colored) {
                for (Vertex vertex : this.vertices) {
                    vertex.color = null;
                }
            }
            this.optimizeVertexOrder(config.generateTangents);
            GeometryConfig.AttributeArrayConfig[] vertexAttribArrays = this.createVertexAttribArrays(config);
            ClientArrayConfig[] texCoordArrays = new ClientArrayConfig[this.vertices.isEmpty() ? 1 : ((Vertex)this.vertices.get((int)0)).extras.size() + 1];
            for (int ii = 0; ii < texCoordArrays.length; ++ii) {
                texCoordArrays[ii] = new ClientArrayConfig(2);
            }
            ClientArrayConfig colorArray = this.colored ? new ClientArrayConfig(4) : null;
            ClientArrayConfig normalArray = new ClientArrayConfig(3);
            ClientArrayConfig vertexArray = new ClientArrayConfig(3);
            ArrayList<ClientArrayConfig> arrays = new ArrayList<ClientArrayConfig>();
            if (vertexAttribArrays != null) {
                Collections.addAll(arrays, vertexAttribArrays);
            }
            Collections.addAll(arrays, texCoordArrays);
            if (colorArray != null) {
                arrays.add(colorArray);
            }
            arrays.add(normalArray);
            arrays.add(vertexArray);
            int offset = 0;
            for (ClientArrayConfig array : arrays) {
                array.offset = offset;
                offset += array.getElementBytes();
            }
            int stride = offset;
            int vsize = stride / 4;
            FloatBuffer vbuf = BufferUtils.createFloatBuffer((int)(this.vertices.size() * vsize));
            for (ClientArrayConfig array : arrays) {
                array.stride = stride;
                array.floatArray = vbuf;
            }
            Box bounds = new Box(Vector3f.MAX_VALUE, Vector3f.MIN_VALUE);
            for (Vertex vertex : this.vertices) {
                bounds.addLocal(new Vector3f(vertex.location));
            }
            bounds.expandLocal(config.boundsExpansion, config.boundsExpansion, config.boundsExpansion);
            return new ModelConfig.VisibleMesh(this.texture, StringUtil.isBlank((String)this.tag) ? this.getDefaultTag() : this.tag, this.createGeometry(bounds, vertexAttribArrays, texCoordArrays, colorArray, normalArray, vertexArray));
        }

        public CollisionMesh createCollisionMesh() {
            Vector3f[] vectors = new Vector3f[this.indices.size()];
            for (int ii = 0; ii < vectors.length; ++ii) {
                Vertex vertex = (Vertex)this.vertices.get(this.indices.get(ii));
                vectors[ii] = new Vector3f(vertex.location);
            }
            return new CollisionMesh(vectors);
        }

        protected GeometryConfig.AttributeArrayConfig[] createVertexAttribArrays(ModelConfig.Imported config) {
            GeometryConfig.AttributeArrayConfig[] attributeArrayConfigArray;
            if (config.generateTangents) {
                GeometryConfig.AttributeArrayConfig[] attributeArrayConfigArray2 = new GeometryConfig.AttributeArrayConfig[1];
                attributeArrayConfigArray = attributeArrayConfigArray2;
                attributeArrayConfigArray2[0] = new GeometryConfig.AttributeArrayConfig(3, "tangent");
            } else {
                attributeArrayConfigArray = null;
            }
            return attributeArrayConfigArray;
        }

        protected String getDefaultTag() {
            return "default";
        }

        protected GeometryConfig createGeometry(Box bounds, GeometryConfig.AttributeArrayConfig[] vertexAttribArrays, ClientArrayConfig[] texCoordArrays, ClientArrayConfig colorArray, ClientArrayConfig normalArray, ClientArrayConfig vertexArray) {
            FloatBuffer vbuf = vertexArray.floatArray;
            for (Vertex vertex : this.vertices) {
                vertex.get(vbuf);
            }
            vbuf.rewind();
            return new GeometryConfig.IndexedStored(bounds, GeometryConfig.Mode.TRIANGLES, vertexAttribArrays, texCoordArrays, colorArray, normalArray, vertexArray, 0, this.vertices.size() - 1, this.createIndexBuffer());
        }

        @Override
        protected boolean containsCollisionMesh() {
            return this.name.contains("collision") || super.containsCollisionMesh();
        }

        protected void transformVertices(Matrix4f vtrans) {
            Matrix4f ntrans = vtrans.invertAffine().transposeLocal();
            for (Vertex vertex : this.vertices) {
                vertex.transform(vtrans, ntrans);
            }
        }

        protected void optimizeVertexOrder(boolean generateTangents) {
            LinkedHashSet<Triangle> triangles = new LinkedHashSet<Triangle>();
            int nn = this.indices.size();
            for (int ii = 0; ii < nn; ii += 3) {
                Vertex[] tverts = new Vertex[]{(Vertex)this.vertices.get(this.indices.get(ii)), (Vertex)this.vertices.get(this.indices.get(ii + 1)), (Vertex)this.vertices.get(this.indices.get(ii + 2))};
                Triangle triangle = new Triangle(tverts);
                for (Vertex tvert : tverts) {
                    if (tvert.triangles == null) {
                        tvert.triangles = new ArrayList();
                    }
                    tvert.triangles.add(triangle);
                }
                triangles.add(triangle);
            }
            if (generateTangents) {
                for (Vertex vertex : this.vertices) {
                    vertex.generateTangent();
                }
            }
            for (Vertex vertex : this.vertices) {
                vertex.updateScore(Integer.MAX_VALUE);
            }
            this.vertices.clear();
            this.indices.clear();
            HashArrayList<Vertex> vcache = new HashArrayList<Vertex>();
            while (!triangles.isEmpty()) {
                Triangle bestTriangle = null;
                float bestScore = -1.0f;
                for (Vertex vertex : vcache) {
                    for (Triangle triangle : vertex.triangles) {
                        float score = triangle.getScore();
                        if (!(score > bestScore)) continue;
                        bestTriangle = triangle;
                        bestScore = score;
                    }
                }
                if (bestTriangle == null) {
                    for (Triangle triangle : triangles) {
                        float score = triangle.getScore();
                        if (!(score > bestScore)) continue;
                        bestTriangle = triangle;
                        bestScore = score;
                    }
                }
                triangles.remove(bestTriangle);
                for (Vertex vertex : bestTriangle.vertices) {
                    this.addVertex(vertex);
                    vertex.triangles.remove(bestTriangle);
                    vcache.remove(vertex);
                    vcache.add(0, vertex);
                }
                int nn2 = vcache.size();
                for (int ii = 0; ii < nn2; ++ii) {
                    ((Vertex)vcache.get(ii)).updateScore(ii);
                }
                while (vcache.size() > 64) {
                    vcache.remove(vcache.size() - 1);
                }
            }
        }

        protected ShortBuffer createIndexBuffer() {
            ShortBuffer ibuf = BufferUtils.createShortBuffer((int)this.indices.size());
            for (int idx : this.indices) {
                ibuf.put((short)idx);
            }
            ibuf.rewind();
            return ibuf;
        }
    }

    public static class NodeDef
    extends SpatialDef {
        public ArticulatedConfig.Node createNode(ArticulatedConfig config, boolean haveCollisionMesh) {
            ArticulatedConfig.Node[] children = this.createChildNodes(config, haveCollisionMesh);
            Transform3D transform = this.parentDef == null ? new Transform3D() : ModelDef.createTransform(this.translation, this.rotation, this.scale, config.scale);
            return new ArticulatedConfig.Node(this.name, transform, children);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SpatialDef {
        public String name;
        public String parent;
        public float[] translation;
        public float[] rotation;
        public float[] scale;
        public SpatialDef parentDef;
        public ArrayList<SpatialDef> childDefs = new ArrayList();
        protected Matrix4f _transformMatrix;

        public ModelConfig.MeshSet createMeshes(ModelConfig.Imported config) {
            this.clearTransforms(config);
            HashMap<Object, TriMeshDef> meshes = new HashMap<Object, TriMeshDef>();
            this.mergeMeshes(meshes);
            if (meshes.isEmpty()) {
                return null;
            }
            ArrayList<ModelConfig.VisibleMesh> visible = new ArrayList<ModelConfig.VisibleMesh>();
            CollisionMesh collision = null;
            for (Map.Entry<Object, TriMeshDef> entry : meshes.entrySet()) {
                TriMeshDef mesh = entry.getValue();
                if ("collision".equals(entry.getKey())) {
                    collision = mesh.createCollisionMesh();
                    continue;
                }
                visible.add(mesh.createVisibleMesh(config));
            }
            if (collision == null) {
                TriMeshDef mesh = new TriMeshDef();
                this.mergeMeshes(mesh);
                collision = mesh.createCollisionMesh();
            }
            return new ModelConfig.MeshSet(visible.toArray(new ModelConfig.VisibleMesh[visible.size()]), collision);
        }

        public void update(ArticulatedConfig config) {
            this.clearTransforms(config);
            HashMap<Object, SkinMeshDef> meshes = new HashMap<Object, SkinMeshDef>();
            HashSet<String> bones = new HashSet<String>();
            this.mergeSkinMeshes(meshes, bones);
            boolean haveCollisionMesh = this.containsCollisionMesh();
            config.root = this.createNode(config, haveCollisionMesh);
            ArrayList<ModelConfig.VisibleMesh> visible = new ArrayList<ModelConfig.VisibleMesh>();
            CollisionMesh collision = null;
            for (Map.Entry<Object, SkinMeshDef> entry : meshes.entrySet()) {
                SkinMeshDef mesh = entry.getValue();
                if ("collision".equals(entry.getKey())) {
                    collision = mesh.createCollisionMesh();
                    continue;
                }
                mesh.createSkinMeshes(config, visible);
            }
            if (!haveCollisionMesh && !visible.isEmpty()) {
                TriMeshDef mesh = new TriMeshDef();
                this.mergeSkinMeshes(mesh);
                collision = mesh.createCollisionMesh();
            }
            config.skin = new ModelConfig.MeshSet(visible.toArray(new ModelConfig.VisibleMesh[visible.size()]), collision);
            config.initTransientFields();
        }

        protected void clearTransforms(ModelConfig.Imported config) {
            this.clearTransform(config.scale);
            if (config.ignoreRootTransforms) {
                for (SpatialDef child : this.childDefs) {
                    child.clearTransform(1.0f);
                }
            }
        }

        public void mergeSkinMeshes(HashMap<Object, SkinMeshDef> meshes, HashSet<String> bones) {
            for (SpatialDef childDef : this.childDefs) {
                childDef.mergeSkinMeshes(meshes, bones);
            }
        }

        public void removeBoneWeights(String bone) {
            for (SpatialDef childDef : this.childDefs) {
                childDef.removeBoneWeights(bone);
            }
        }

        public void mergeSkinMeshes(TriMeshDef mesh) {
            for (SpatialDef child : this.childDefs) {
                child.mergeSkinMeshes(mesh);
            }
        }

        public abstract ArticulatedConfig.Node createNode(ArticulatedConfig var1, boolean var2);

        public ArticulatedConfig.Node[] createChildNodes(ArticulatedConfig config, boolean haveCollisionMesh) {
            ArticulatedConfig.Node[] children = new ArticulatedConfig.Node[this.childDefs.size()];
            for (int ii = 0; ii < children.length; ++ii) {
                children[ii] = this.childDefs.get(ii).createNode(config, haveCollisionMesh);
            }
            return children;
        }

        public void mergeMeshes(HashMap<Object, TriMeshDef> meshes) {
            for (SpatialDef child : this.childDefs) {
                child.mergeMeshes(meshes);
            }
        }

        public void mergeMeshes(TriMeshDef mesh) {
            for (SpatialDef child : this.childDefs) {
                child.mergeMeshes(mesh);
            }
        }

        public Matrix4f getTransformMatrix() {
            if (this._transformMatrix == null) {
                this._transformMatrix = ModelDef.createMatrix(this.translation, this.rotation, this.scale);
                if (this.parentDef != null) {
                    this.parentDef.getTransformMatrix().mult(this._transformMatrix, this._transformMatrix);
                }
            }
            return this._transformMatrix;
        }

        protected void clearTransform(float scale) {
            this.translation = new float[]{0.0f, 0.0f, 0.0f};
            this.rotation = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            this.scale = new float[]{scale, scale, scale};
        }

        protected boolean containsCollisionMesh() {
            for (SpatialDef child : this.childDefs) {
                if (!child.containsCollisionMesh()) continue;
                return true;
            }
            return false;
        }
    }
}

