/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.expr.Scope;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.Log;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.geometry.config.TransformedGeometry;
import com.threerings.opengl.material.config.GeometryMaterial;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.Static;
import com.threerings.opengl.model.config.CompoundConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.config.StaticConfig;
import com.threerings.opengl.model.config.StaticSetConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class MergedStaticConfig
extends ModelConfig.Implementation {
    @Editable
    public CompoundConfig.ComponentModel[] models;
    @DeepOmit
    protected transient SoftReference<StaticConfig.Resolved> _resolved;

    public MergedStaticConfig() {
        this.models = new CompoundConfig.ComponentModel[0];
    }

    public MergedStaticConfig(CompoundConfig.ComponentModel[] models) {
        this.models = models;
    }

    public void getUpdateReferences(ConfigReferenceSet refs) {
        for (CompoundConfig.ComponentModel cmodel : this.models) {
            refs.add(ModelConfig.class, cmodel.model);
        }
    }

    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        StaticConfig.Resolved resolved;
        StaticConfig.Resolved resolved2 = resolved = this._resolved == null ? null : this._resolved.get();
        if (resolved == null) {
            resolved = this.resolve(ctx);
            this._resolved = new SoftReference<StaticConfig.Resolved>(resolved);
        }
        if (impl instanceof Static) {
            ((Static)impl).setConfig(ctx, resolved);
        } else {
            impl = new Static(ctx, scope, resolved);
        }
        return impl;
    }

    public void invalidate() {
        this._resolved = null;
    }

    protected StaticConfig.Resolved resolve(GlContext ctx) {
        ConfigManager cfgmgr = ctx.getConfigManager();
        IdentityHashMap glists = Maps.newIdentityHashMap();
        HashMap mmap = Maps.newHashMap();
        ArrayList cmeshes = Lists.newArrayList();
        final Box bounds = new Box();
        int influenceFlags = 0;
        for (CompoundConfig.ComponentModel cmodel : this.models) {
            ModelConfig config = cfgmgr.getConfig(ModelConfig.class, cmodel.model);
            ModelConfig.Implementation original = config == null ? null : config.getOriginal();
            ModelConfig.MeshSet mset = null;
            if (original instanceof StaticConfig) {
                mset = ((StaticConfig)original).meshes;
            } else if (original instanceof StaticSetConfig) {
                StaticSetConfig ssconfig = (StaticSetConfig)original;
                if (ssconfig.model != null && ssconfig.meshes != null) {
                    mset = ssconfig.meshes.get(ssconfig.model);
                }
            } else if (original != null) {
                Log.log.warning((Object)"Merged model not of static type.", new Object[]{"model", cmodel.model, "class", original.getClass()});
            }
            if (mset == null) continue;
            bounds.addLocal(mset.bounds.transform(cmodel.transform));
            if (mset.collision != null) {
                cmeshes.add(new TransformedCollision(mset.collision, cmodel.transform));
            }
            ModelConfig.Imported imported = (ModelConfig.Imported)original;
            for (ModelConfig.VisibleMesh mesh : mset.visible) {
                MaterialConfig material = Model.getMaterialConfig(ctx, mesh.texture, mesh.tag, imported.materialMappings, mmap);
                List glist = (List)glists.get(material);
                if (glist == null) {
                    glist = Lists.newArrayList();
                    glists.put(material, glist);
                }
                glist.add(new TransformedGeometry(mesh.geometry, cmodel.transform));
            }
            mmap.clear();
            influenceFlags |= imported.influences.getFlags();
        }
        ArrayList gmats = Lists.newArrayList();
        for (Map.Entry entry : glists.entrySet()) {
            MaterialConfig material = (MaterialConfig)entry.getKey();
            List glist = (List)entry.getValue();
            while (!glist.isEmpty()) {
                GeometryConfig merged = ((TransformedGeometry)glist.get((int)0)).geometry.merge(glist);
                if (merged != null) {
                    gmats.add(new GeometryMaterial(merged, material));
                    continue;
                }
                glist.remove(0);
            }
        }
        final TransformedCollision[] tcollisions = cmeshes.toArray(new TransformedCollision[cmeshes.size()]);
        CollisionMesh collision = new CollisionMesh(){

            public Box getBounds() {
                return bounds;
            }

            public boolean getIntersection(Ray3D ray, Vector3f result) {
                Vector3f closest = result;
                for (TransformedCollision tcoll : tcollisions) {
                    if (!tcoll.bounds.intersects(ray) || !tcoll.collision.getIntersection(ray.transform(tcoll.invTransform), result)) continue;
                    tcoll.transform.transformPointLocal(result);
                    result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
                }
                return result != closest;
            }
        };
        return new StaticConfig.Resolved(bounds, collision, gmats.toArray(new GeometryMaterial[gmats.size()]), influenceFlags);
    }

    protected static class TransformedCollision {
        public final CollisionMesh collision;
        public final Transform3D transform;
        public final Transform3D invTransform;
        public final Box bounds;

        public TransformedCollision(CollisionMesh collision, Transform3D transform) {
            this.collision = collision;
            this.transform = transform;
            this.invTransform = transform.invert();
            this.bounds = collision.getBounds().transform(transform);
        }
    }
}

