/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.editor.util.EditorContext;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.Transform3DExpression;
import com.threerings.math.Transform3D;
import com.threerings.opengl.Log;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.config.ActionConfig;
import com.threerings.opengl.model.tools.AnimationDef;
import com.threerings.opengl.model.tools.xml.AnimationParser;
import com.threerings.opengl.util.GlContext;
import com.threerings.probs.FloatVariable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import com.threerings.util.Shallow;

public class AnimationConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Imported();
    protected static AnimationParser _parser;

    public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
        return this.implementation.getAnimationImplementation(ctx, scope, impl);
    }

    public void updateFromSource(EditorContext ctx, boolean force) {
        this.implementation.updateFromSource(ctx, force);
    }

    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class ComponentAnimation
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float speed = 1.0f;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;
    }

    public static class TargetTransform
    extends DeepObject
    implements Exportable {
        @Editable
        public String[] targets = new String[0];
        @Editable
        public Transform3DExpression expression = new Transform3DExpression.Constant();
    }

    public static class FrameAction
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float frame;
        @Editable
        public ActionConfig action = new ActionConfig.CallFunction();
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(AnimationConfig.class, this.animation);
        }

        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            AnimationConfig config = ctx.getConfigManager().getConfig(AnimationConfig.class, this.animation);
            return config == null ? null : config.getAnimationImplementation(ctx, scope, impl);
        }
    }

    public static class Sequential
    extends Original {
        @Editable
        public boolean loop;
        @Editable
        public ComponentAnimation[] animations = new ComponentAnimation[0];

        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            if (this.animations.length == 0) {
                impl = null;
            } else if (impl instanceof Animation.Sequential) {
                ((Animation.Sequential)impl).setConfig(this);
            } else {
                impl = new Animation.Sequential(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class Procedural
    extends Original {
        @Editable(min=0.0, step=0.01)
        public float duration;
        @Editable(min=0.0, step=0.01)
        public FloatVariable offset = new FloatVariable.Constant(0.0f);
        @Editable
        public TargetTransform[] transforms = new TargetTransform[0];

        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            if (impl instanceof Animation.Procedural) {
                ((Animation.Procedural)impl).setConfig(this);
            } else {
                impl = new Animation.Procedural(ctx, scope, this);
            }
            return impl;
        }

        public void invalidate() {
            for (TargetTransform transform : this.transforms) {
                transform.expression.invalidate();
            }
        }
    }

    public static class Imported
    extends Original {
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float transition;
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float speed = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="t")
        public float scale = 0.01f;
        @Editable(hgroup="l")
        public boolean loop;
        @Editable(hgroup="l")
        public boolean skipLastFrame = true;
        @Editable(min=0.0, step=0.01, weight=2.0)
        public FloatVariable offset = new FloatVariable.Constant(0.0f);
        @Editable(weight=2.0)
        public FrameAction[] actions = new FrameAction[0];
        public float rate;
        @Shallow
        public String[] targets;
        @Shallow
        public Transform3D[][] transforms;
        protected String _source;
        @DeepOmit
        protected transient boolean _reload;

        @Editable(editor="resource", weight=-1.0, nullable=true)
        @FileConstraints(description="m.exported_anims", extensions={".mxml"}, directory="exported_anim_dir")
        public void setSource(String source) {
            this._source = source;
            this._reload = true;
        }

        @Editable
        public String getSource() {
            return this._source;
        }

        @Editable(step=0.01, hgroup="l", weight=1.0, depends={"transition", "source", "speed", "duration"})
        public void setDuration(float duration) {
        }

        @Editable
        public float getDuration() {
            return this.transition + (this.transforms == null ? 0.0f : (float)(this.transforms.length - 1) / this.getScaledRate());
        }

        public float getScaledRate() {
            return this.speed * this.rate;
        }

        public void updateFromSource(EditorContext ctx, boolean force) {
            if (!this._reload && !force) {
                return;
            }
            this._reload = false;
            if (this._source == null) {
                this.updateFromSource(null);
                return;
            }
            if (_parser == null) {
                _parser = new AnimationParser();
            }
            try {
                this.updateFromSource(_parser.parseAnimation(ctx.getResourceManager().getResource(this._source)));
            }
            catch (Exception e) {
                Log.log.warning((Object)("Error parsing animation [source=" + this._source + "]."), new Object[]{e});
                return;
            }
        }

        public Animation.Implementation getAnimationImplementation(GlContext ctx, Scope scope, Animation.Implementation impl) {
            if (this.targets == null) {
                return null;
            }
            if (impl instanceof Animation.Imported) {
                ((Animation.Imported)impl).setConfig(this);
            } else {
                impl = new Animation.Imported(ctx, scope, this);
            }
            return impl;
        }

        protected void updateFromSource(AnimationDef def) {
            if (def == null) {
                this.targets = null;
                this.transforms = null;
            } else {
                def.update(this);
            }
        }
    }

    public static abstract class Original
    extends Implementation {
        @Editable(hgroup="p")
        public int priority;
        @Editable(hgroup="p")
        public boolean override = true;
        @Editable(min=0.0, max=1.0, step=0.01, hgroup="w")
        public float weight = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="w")
        public float blendIn;
        @Editable(min=0.0, step=0.01, hgroup="w")
        public float blendOut;
    }

    @EditorTypes(value={Imported.class, Procedural.class, Sequential.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void updateFromSource(EditorContext ctx, boolean force) {
        }

        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Animation.Implementation getAnimationImplementation(GlContext var1, Scope var2, Animation.Implementation var3);

        public void invalidate() {
        }
    }
}

