/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.math.Box;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.material.Surface;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.StaticConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;

public class Static
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected StaticConfig.Resolved _config;
    protected Surface[] _surfaces;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected TransformState _transformState = new TransformState();
    @Scoped
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();

    public Static(GlContext ctx, Scope parentScope, StaticConfig.Resolved config) {
        super(parentScope);
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, StaticConfig.Resolved config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    public void enqueue() {
        Transform3D modelview = this._transformState.getModelview();
        this._parentViewTransform.compose(this._localTransform, modelview);
        this._transformState.setDirty(true);
    }

    public int getInfluenceFlags() {
        return this._config.influenceFlags;
    }

    public Box getBounds() {
        return this._bounds;
    }

    public void updateBounds() {
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this._config.bounds.transform(this._worldTransform, this._nbounds);
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
    }

    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
    }

    public void dumpInfo(String prefix) {
        System.out.println(prefix + "Static: " + this._worldTransform + " " + this._bounds);
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        if (this._config.collision == null || !this._bounds.intersects(ray) || !this._config.collision.getIntersection(ray.transform(this._worldTransform.invert()), result)) {
            return false;
        }
        this._worldTransform.transformPointLocal(result);
        return true;
    }

    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
        for (Surface surface : this._surfaces) {
            surface.composite();
        }
    }

    protected void updateFromConfig() {
        if (this._surfaces != null) {
            for (Surface surface : this._surfaces) {
                surface.dispose();
            }
        }
        this._surfaces = Static.createSurfaces(this._ctx, this, this._config.gmats);
        this.updateBounds();
    }
}

