/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material.config;

import com.google.common.base.Objects;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.compositor.config.RenderSchemeConfig;
import com.threerings.opengl.material.config.MaterialRewriter;
import com.threerings.opengl.material.config.TechniqueConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;

public class MaterialConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original();

    public TechniqueConfig getTechnique(GlContext ctx, String scheme) {
        return this.implementation.getTechnique(ctx, scheme);
    }

    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<MaterialConfig> material;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(MaterialConfig.class, this.material);
        }

        public TechniqueConfig getTechnique(GlContext ctx, String scheme) {
            if (this.material == null) {
                return null;
            }
            MaterialConfig config = ctx.getConfigManager().getConfig(MaterialConfig.class, this.material);
            return config == null ? null : config.getTechnique(ctx, scheme);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Original
    extends Implementation {
        @Editable
        public TechniqueConfig[] techniques = new TechniqueConfig[]{new TechniqueConfig()};
        @DeepOmit
        protected transient ArrayList<TechniqueConfig> _processedTechniques;
        @DeepOmit
        protected transient boolean _compatibilityMode;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            for (TechniqueConfig technique : this.techniques) {
                technique.getUpdateReferences(refs);
            }
        }

        @Override
        public TechniqueConfig getTechnique(GlContext ctx, String scheme) {
            MaterialRewriter rewriter;
            ArrayList<TechniqueConfig> processed = this.getProcessedTechniques(ctx);
            int nn = processed.size();
            for (int ii = 0; ii < nn; ++ii) {
                TechniqueConfig technique = processed.get(ii);
                if (!Objects.equal((Object)technique.scheme, (Object)scheme)) continue;
                return technique;
            }
            RenderSchemeConfig sconfig = scheme == null ? null : ctx.getConfigManager().getConfig(RenderSchemeConfig.class, scheme);
            int nn2 = processed.size();
            for (int ii = 0; ii < nn2; ++ii) {
                TechniqueConfig technique = processed.get(ii);
                RenderSchemeConfig tconfig = technique.getSchemeConfig(ctx);
                if (!(sconfig == null ? tconfig == null || tconfig.isCompatibleWith(sconfig) : sconfig.isCompatibleWith(tconfig))) continue;
                return technique;
            }
            MaterialRewriter materialRewriter = rewriter = sconfig == null ? null : sconfig.getMaterialRewriter();
            if (rewriter == null) {
                return null;
            }
            int nn3 = processed.size();
            for (int ii = 0; ii < nn3; ++ii) {
                TechniqueConfig rewritten;
                TechniqueConfig technique = processed.get(ii);
                RenderSchemeConfig tconfig = technique.getSchemeConfig(ctx);
                if (tconfig != null && !tconfig.isCompatibleWith(null) || (rewritten = rewriter.rewrite(technique)) == null) continue;
                rewritten.scheme = scheme;
                processed.add(rewritten);
                return rewritten;
            }
            return null;
        }

        @Override
        public void invalidate() {
            this._processedTechniques = null;
            for (TechniqueConfig technique : this.techniques) {
                technique.invalidate();
            }
        }

        protected ArrayList<TechniqueConfig> getProcessedTechniques(GlContext ctx) {
            boolean compatibility = ctx.getApp().getCompatibilityMode();
            if (this._processedTechniques == null || this._compatibilityMode != compatibility) {
                this._processedTechniques = new ArrayList(this.techniques.length);
                ArrayList<TechniqueConfig> fallbacks = new ArrayList<TechniqueConfig>(0);
                for (TechniqueConfig technique : this.techniques) {
                    TechniqueConfig processed = technique.process(ctx, false);
                    if (processed == null) {
                        TechniqueConfig fallback = technique.process(ctx, true);
                        if (fallback == null) continue;
                        fallbacks.add(fallback);
                        continue;
                    }
                    this._processedTechniques.add(processed);
                }
                this._processedTechniques.addAll(fallbacks);
                this._compatibilityMode = compatibility;
            }
            return this._processedTechniques;
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public abstract void getUpdateReferences(ConfigReferenceSet var1);

        public abstract TechniqueConfig getTechnique(GlContext var1, String var2);

        public void invalidate() {
        }
    }
}

