/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.util;

import com.google.common.collect.Maps;
import com.samskivert.util.IntTuple;
import com.samskivert.util.StringUtil;
import com.threerings.opengl.gui.event.ControllerEvent;
import com.threerings.opengl.gui.event.ControllerListener;
import com.threerings.opengl.gui.event.KeyEvent;
import com.threerings.opengl.gui.event.KeyListener;
import com.threerings.opengl.gui.event.MouseAdapter;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.MouseWheelListener;
import com.threerings.util.MessageBundle;
import java.util.Map;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;

public class PseudoKeys {
    public static final int KEY_BUTTON1 = 256;
    public static final int KEY_BUTTON2 = 257;
    public static final int KEY_BUTTON3 = 258;
    public static final int KEY_WHEEL_UP = 259;
    public static final int KEY_WHEEL_DOWN = 260;
    public static final int KEY_CONTROLLER_BUTTON = 261;
    public static final int KEY_CONTROLLER_AXIS_POSITIVE = 262;
    public static final int KEY_CONTROLLER_AXIS_NEGATIVE = 263;
    public static final int KEY_CONTROLLER_POV_X_POSITIVE = 264;
    public static final int KEY_CONTROLLER_POV_X_NEGATIVE = 265;
    public static final int KEY_CONTROLLER_POV_Y_POSITIVE = 266;
    public static final int KEY_CONTROLLER_POV_Y_NEGATIVE = 267;
    public static final int KEY_BUTTON4 = 268;
    public static final int KEY_BUTTON5 = 269;

    public static int getMouseKey(int button) {
        switch (button) {
            case 0: {
                return 256;
            }
            case 1: {
                return 257;
            }
            case 2: {
                return 258;
            }
            case 3: {
                return 268;
            }
            case 4: {
                return 269;
            }
        }
        return 0;
    }

    public static int getControllerKey(int type, int controllerIndex, int controlIndex) {
        return controllerIndex << 24 | controlIndex << 16 | type;
    }

    public static boolean isValid(int key) {
        switch (PseudoKeys.getType(key)) {
            case 261: {
                int controllerIndex = PseudoKeys.getControllerIndex(key);
                return controllerIndex < Controllers.getControllerCount() && PseudoKeys.getControlIndex(key) < Controllers.getController((int)controllerIndex).getButtonCount();
            }
            case 262: 
            case 263: {
                int controllerIndex = PseudoKeys.getControllerIndex(key);
                return controllerIndex < Controllers.getControllerCount() && PseudoKeys.getControlIndex(key) < Controllers.getController((int)controllerIndex).getAxisCount();
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                return PseudoKeys.getControllerIndex(key) < Controllers.getControllerCount();
            }
        }
        return true;
    }

    public static String getDesc(MessageBundle msgs, int key) {
        switch (PseudoKeys.getType(key)) {
            case 261: {
                int idx = PseudoKeys.getControllerIndex(key);
                return msgs.get("m.controller_button", new String[]{String.valueOf(idx), Controllers.getController((int)idx).getButtonName(PseudoKeys.getControlIndex(key))});
            }
            case 262: {
                int idx = PseudoKeys.getControllerIndex(key);
                return msgs.get("m.controller_axis_positive", new String[]{String.valueOf(idx), Controllers.getController((int)idx).getAxisName(PseudoKeys.getControlIndex(key))});
            }
            case 263: {
                int idx = PseudoKeys.getControllerIndex(key);
                return msgs.get("m.controller_axis_negative", new String[]{String.valueOf(idx), Controllers.getController((int)idx).getAxisName(PseudoKeys.getControlIndex(key))});
            }
            case 264: {
                return msgs.get("m.controller_pov_x_positive", new String[]{String.valueOf(PseudoKeys.getControllerIndex(key))});
            }
            case 265: {
                return msgs.get("m.controller_pov_x_negative", new String[]{String.valueOf(PseudoKeys.getControllerIndex(key))});
            }
            case 266: {
                return msgs.get("m.controller_pov_y_positive", new String[]{String.valueOf(PseudoKeys.getControllerIndex(key))});
            }
            case 267: {
                return msgs.get("m.controller_pov_y_negative", new String[]{String.valueOf(PseudoKeys.getControllerIndex(key))});
            }
        }
        String name = PseudoKeys.getName(key);
        String mkey = "m." + StringUtil.toUSLowerCase((String)name);
        return msgs.exists(mkey) ? msgs.get(mkey) : name;
    }

    public static String getName(int key) {
        switch (PseudoKeys.getType(key)) {
            case 256: {
                return "BUTTON1";
            }
            case 257: {
                return "BUTTON2";
            }
            case 258: {
                return "BUTTON3";
            }
            case 259: {
                return "WHEEL_UP";
            }
            case 260: {
                return "WHEEL_DOWN";
            }
            case 261: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_BUTTON" + PseudoKeys.getControlIndex(key);
            }
            case 262: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_AXIS" + PseudoKeys.getControlIndex(key) + "_POSITIVE";
            }
            case 263: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_AXIS" + PseudoKeys.getControlIndex(key) + "_NEGATIVE";
            }
            case 264: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_X_POSITIVE";
            }
            case 265: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_X_NEGATIVE";
            }
            case 266: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_Y_POSITIVE";
            }
            case 267: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_Y_NEGATIVE";
            }
        }
        return Keyboard.getKeyName((int)key);
    }

    public static int getType(int key) {
        return key & 0xFFFF;
    }

    public static int getControllerIndex(int key) {
        return key >>> 24;
    }

    public static int getControlIndex(int key) {
        return key >> 16 & 0xFF;
    }

    public static class Unifier
    extends MouseAdapter
    implements KeyListener,
    MouseWheelListener,
    ControllerListener {
        protected Observer _observer;
        protected Map<IntTuple, Integer> _axes = Maps.newHashMap();
        protected Map<Integer, Integer> _povx = Maps.newHashMap();
        protected Map<Integer, Integer> _povy = Maps.newHashMap();
        protected boolean _consume;

        public Unifier(Observer observer) {
            this._observer = observer;
        }

        public Unifier(boolean consume) {
            this._consume = consume;
        }

        public Unifier() {
            this(false);
        }

        public void keyPressed(long when, int key, float amount) {
            if (this._observer != null) {
                this._observer.keyPressed(when, key, amount);
            }
        }

        public void keyReleased(long when, int key) {
            if (this._observer != null) {
                this._observer.keyReleased(when, key);
            }
        }

        public void keyPressed(KeyEvent event) {
            if (!event.isConsumed() && !event.isRepeat()) {
                this.keyPressed(event.getWhen(), event.getKeyCode(), 1.0f);
                if (this._consume) {
                    event.consume();
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            if (!event.isConsumed()) {
                this.keyReleased(event.getWhen(), event.getKeyCode());
                if (this._consume) {
                    event.consume();
                }
            }
        }

        public void mouseWheeled(MouseEvent event) {
            if (event.isConsumed()) {
                return;
            }
            long when = event.getWhen();
            int delta = event.getDelta();
            if (delta > 0) {
                this.keyPressed(when, 259, delta);
                this.keyReleased(when, 259);
            } else {
                this.keyPressed(when, 260, -delta);
                this.keyReleased(when, 260);
            }
            if (this._consume) {
                event.consume();
            }
        }

        public void controllerPressed(ControllerEvent event) {
            if (!event.isConsumed()) {
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(261, event.getController().getIndex(), event.getControlIndex()), 1.0f);
                if (this._consume) {
                    event.consume();
                }
            }
        }

        public void controllerReleased(ControllerEvent event) {
            if (!event.isConsumed()) {
                this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(261, event.getController().getIndex(), event.getControlIndex()));
                if (this._consume) {
                    event.consume();
                }
            }
        }

        public void controllerMoved(ControllerEvent event) {
            float dead;
            if (event.isConsumed()) {
                return;
            }
            Controller controller = event.getController();
            int controllerIndex = controller.getIndex();
            int axisIndex = event.getControlIndex();
            float value = controller.getAxisValue(axisIndex);
            if (value > (dead = controller.getDeadZone(axisIndex))) {
                Integer okey = this._axes.put(new IntTuple(controllerIndex, axisIndex), 262);
                if (okey != null && okey == 263) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, axisIndex));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(262, controllerIndex, axisIndex), value);
            } else if (value < -dead) {
                Integer okey = this._axes.put(new IntTuple(controllerIndex, axisIndex), 263);
                if (okey != null && okey == 262) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, axisIndex));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(263, controllerIndex, axisIndex), -value);
            } else {
                Integer okey = this._axes.remove(new IntTuple(controllerIndex, axisIndex));
                if (okey != null) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, axisIndex));
                }
            }
            if (this._consume) {
                event.consume();
            }
        }

        public void controllerPovXMoved(ControllerEvent event) {
            if (event.isConsumed()) {
                return;
            }
            Controller controller = event.getController();
            int controllerIndex = controller.getIndex();
            float value = controller.getPovX();
            if (value > 0.0f) {
                Integer okey = this._povx.put(controllerIndex, 264);
                if (okey != null && okey == 265) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(264, controllerIndex, 0), value);
            } else if (value < 0.0f) {
                Integer okey = this._povx.put(controllerIndex, 265);
                if (okey != null && okey == 264) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(265, controllerIndex, 0), -value);
            } else {
                Integer okey = this._povx.remove(controllerIndex);
                if (okey != null) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
            }
            if (this._consume) {
                event.consume();
            }
        }

        public void controllerPovYMoved(ControllerEvent event) {
            if (event.isConsumed()) {
                return;
            }
            Controller controller = event.getController();
            int controllerIndex = controller.getIndex();
            float value = controller.getPovY();
            if (value > 0.0f) {
                Integer okey = this._povy.put(controllerIndex, 266);
                if (okey != null && okey == 267) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(266, controllerIndex, 0), value);
            } else if (value < 0.0f) {
                Integer okey = this._povy.put(controllerIndex, 267);
                if (okey != null && okey == 266) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(267, controllerIndex, 0), -value);
            } else {
                Integer okey = this._povy.remove(controllerIndex);
                if (okey != null) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
            }
            if (this._consume) {
                event.consume();
            }
        }

        public void mousePressed(MouseEvent event) {
            if (!event.isConsumed()) {
                this.keyPressed(event.getWhen(), PseudoKeys.getMouseKey(event.getButton()), 1.0f);
                if (this._consume) {
                    event.consume();
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (!event.isConsumed()) {
                this.keyReleased(event.getWhen(), PseudoKeys.getMouseKey(event.getButton()));
                if (this._consume) {
                    event.consume();
                }
            }
        }
    }

    public static class Adapter
    implements Observer {
        public void keyPressed(long when, int key, float amount) {
        }

        public void keyReleased(long when, int key) {
        }
    }

    public static interface Observer {
        public void keyPressed(long var1, int var3, float var4);

        public void keyReleased(long var1, int var3);
    }
}

