/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.tools;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.opengl.GlCanvasTool;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.StretchWindow;
import com.threerings.opengl.gui.UserInterface;
import com.threerings.opengl.gui.config.UserInterfaceConfig;
import com.threerings.opengl.gui.layout.HGroupLayout;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.ChangeBlock;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceTester
extends GlCanvasTool
implements ChangeListener,
ConfigUpdateListener<UserInterfaceConfig> {
    protected JPanel _cpanel;
    protected EditorPanel _epanel;
    protected DraggableSpinner _width;
    protected DraggableSpinner _height;
    protected ChangeBlock _block = new ChangeBlock();
    protected Root _root;
    protected UserInterface _userInterface;
    protected static Preferences _prefs = Preferences.userNodeForPackage(InterfaceTester.class);

    public static void main(String[] args) {
        new InterfaceTester(args.length > 0 ? args[0] : null).startup();
    }

    public InterfaceTester(String userInterface) {
        super("interface");
        String path;
        this._frame.setTitle(this._msgs.get("m.title"));
        JMenuBar menubar = new JMenuBar();
        this._frame.setJMenuBar(menubar);
        JMenu file = this.createMenu("file", 70);
        menubar.add(file);
        file.add(this.createMenuItem("quit", 81, 81));
        JMenu edit = this.createMenu("edit", 69);
        menubar.add(edit);
        edit.add(this.createMenuItem("configs", 67, 71));
        edit.add(this.createMenuItem("resources", 82, 82));
        edit.add(this.createMenuItem("preferences", 80, 80));
        JMenu view = this.createMenu("view", 86);
        menubar.add(view);
        this._showStats = this.createCheckBoxMenuItem("stats", 83, 84);
        view.add(this._showStats);
        view.addSeparator();
        view.add(this.createMenuItem("refresh", 70, 70));
        this._cpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._cpanel.setPreferredSize(new Dimension(350, 1));
        this._epanel = new EditorPanel(this);
        this._cpanel.add((Component)((Object)this._epanel));
        JPanel controls = new JPanel();
        this._cpanel.add((Component)controls, GroupLayout.FIXED);
        controls.add(new JLabel(this._msgs.get("m.width")));
        this._width = new DraggableSpinner(-1, -1, Integer.MAX_VALUE, 1);
        controls.add(this._width);
        this._width.setMinimumSize(this._width.getPreferredSize());
        this._width.setMaximumSize(this._width.getPreferredSize());
        this._width.addChangeListener(this);
        controls.add((Component)new Spacer(10, 1));
        controls.add(new JLabel(this._msgs.get("m.height")));
        this._height = new DraggableSpinner(-1, -1, Integer.MAX_VALUE, 1);
        controls.add(this._height);
        this._height.setMinimumSize(this._height.getPreferredSize());
        this._height.setMaximumSize(this._height.getPreferredSize());
        this._height.addChangeListener(this);
        UserInterfaceConfig.Derived impl = new UserInterfaceConfig.Derived();
        if (userInterface != null && (path = this._rsrcmgr.getResourcePath(new File(userInterface))) != null) {
            impl.userInterface = new ConfigReference(path);
        }
        this._epanel.setObject(impl);
        this._epanel.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this._epanel) {
            if (!this._block.enter()) {
                return;
            }
            try {
                this._userInterface.getConfig().wasUpdated();
                Object var3_2 = null;
                this._block.leave();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._block.leave();
                throw throwable;
            }
        } else {
            this._userInterface.setPreferredSize(this._width.getIntValue(), this._height.getIntValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configUpdated(ConfigEvent<UserInterfaceConfig> event) {
        if (!this._block.enter()) {
            return;
        }
        try {
            this._epanel.update();
            this._epanel.validate();
            Object var3_2 = null;
            this._block.leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._block.leave();
            throw throwable;
        }
    }

    @Override
    protected JComponent createCanvasContainer() {
        this._cpanel = GroupLayout.makeVStretchBox((int)5);
        JSplitPane pane = new JSplitPane(1, true, this._canvas, this._cpanel);
        this._canvas.setMinimumSize(new Dimension(1, 1));
        pane.setResizeWeight(1.0);
        pane.setOneTouchExpandable(true);
        return pane;
    }

    @Override
    protected GlCanvasTool.CanvasToolPrefs createEditablePrefs() {
        return new GlCanvasTool.CanvasToolPrefs(_prefs);
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._root = this.createRoot();
        this._root.setModalShade(new Color4f(0.0f, 0.0f, 0.0f, 0.5f));
        StretchWindow window = new StretchWindow(this, new HGroupLayout());
        this._root.addWindow(window);
        UserInterfaceConfig config = new UserInterfaceConfig();
        config.init(this._cfgmgr);
        config.implementation = (UserInterfaceConfig.Derived)this._epanel.getObject();
        config.addListener(this);
        this._userInterface = new UserInterface((GlContext)this, config);
        window.add(this._userInterface);
        this._userInterface.getScope().setParentScope(this);
    }

    @Override
    protected void updateView(float elapsed) {
        super.updateView(elapsed);
        this._root.tick(elapsed);
    }

    @Override
    protected void compositeView() {
        super.compositeView();
        this._root.composite();
    }
}

