/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.text;

import com.samskivert.util.StringUtil;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.gui.text.TextFactory;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTextFactory
extends TextFactory {
    protected boolean _antialias;
    protected int _height;
    protected BufferedImage _stub;
    protected Map<TextAttribute, Font> _attrs = new HashMap<TextAttribute, Font>();
    protected Map<GlowKey, BufferedImage> _cachedGlowBGs = new HashMap<GlowKey, BufferedImage>();
    protected Map<GlowKey, BufferedImage> _cachedGlowFGs = new HashMap<GlowKey, BufferedImage>();
    protected GlowKey _gkey = new GlowKey();
    protected static boolean _isMacOS;
    protected static final char NONE = '!';
    protected static final char BOLD = 'b';
    protected static final char ITALIC = 'i';
    protected static final char UNDERLINE = 'u';
    protected static final char STRIKE = 's';
    protected static final char COLOR = '#';

    public StringTextFactory(Font font, boolean antialias) {
        this._antialias = antialias;
        this._attrs.put(TextAttribute.FONT, font);
        this._stub = new BufferedImage(1, 1, 6);
        this._height = this.createText((String)"J", (Color4f)Color4f.BLACK).getSize().height;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Text createText(String text, Color4f color, int effect, int effectSize, Color4f effectColor, boolean useAdvance) {
        TextLayout layout;
        if (text.equals("")) {
            text = " ";
        }
        Graphics2D gfx = this._stub.createGraphics();
        try {
            if (this._antialias) {
                gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            layout = new TextLayout(this.parseStyledText(text, this._attrs, null, effect != 3).getIterator(), gfx.getFontRenderContext());
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            gfx.dispose();
            throw throwable;
        }
        gfx.dispose();
        return this.createText(text, layout, color, effect, effectSize, effectColor, text.length(), useAdvance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Text[] wrapText(String text, Color4f color, int effect, int effectSize, Color4f effectColor, int maxWidth) {
        if (text.length() == 0) {
            text = " ";
        }
        ArrayList<Text> texts = new ArrayList<Text>();
        Graphics2D gfx = this._stub.createGraphics();
        try {
            if (this._antialias) {
                gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            String[] bare = new String[1];
            AttributedString atext = this.parseStyledText(text, this._attrs, bare, effect != 3);
            LineBreakMeasurer measurer = new LineBreakMeasurer(atext.getIterator(), gfx.getFontRenderContext());
            text = bare[0];
            int pos = 0;
            while (pos < text.length()) {
                int nextret = text.indexOf(10, pos);
                if (nextret == -1) {
                    nextret = text.length();
                }
                TextLayout layout = measurer.nextLayout(maxWidth, nextret, false);
                String origText = text.substring(pos, measurer.getPosition());
                pos = measurer.getPosition();
                if (pos < text.length() && text.charAt(pos) == '\n') {
                    ++pos;
                }
                texts.add(this.createText(origText, layout, color, effect, effectSize, effectColor, origText.length(), true));
            }
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            gfx.dispose();
            throw throwable;
        }
        gfx.dispose();
        return texts.toArray(new Text[texts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Text createText(String origText, final TextLayout layout, Color4f color, int effect, int effectSize, Color4f effectColor, final int length, boolean useAdvance) {
        final Dimension size = new Dimension();
        Rectangle2D bounds = layout.getBounds();
        if (effect == 1 || effect == 4 || _isMacOS) {
            bounds = layout.getOutline(null).getBounds();
        }
        size.width = useAdvance ? (int)Math.round(Math.max(bounds.getX(), 0.0) + (double)layout.getAdvance()) : (int)Math.round(Math.max(bounds.getX(), 0.0) + bounds.getWidth());
        size.height = (int)(layout.getLeading() + layout.getAscent() + layout.getDescent());
        size.width = Math.max(size.width, 1);
        size.height = Math.max(size.height, 1);
        switch (effect) {
            case 2: {
                size.width += effectSize;
                size.height += effectSize;
                break;
            }
            case 1: {
                size.width += effectSize * 2;
                size.height += effectSize * 2;
                break;
            }
            case 4: {
                size.width += effectSize * 2;
                size.height += effectSize * 2;
            }
        }
        BufferedImage bimage = new BufferedImage(size.width, size.height, 6);
        Graphics2D gfx = bimage.createGraphics();
        try {
            if (effect == 1) {
                if (this._antialias) {
                    gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                float tx = effectSize - 1;
                float ty = layout.getAscent() + (float)effectSize;
                gfx.translate(tx, ty);
                if (effectSize > 1) {
                    gfx.setColor(new Color(effectColor.r, effectColor.g, effectColor.b, effectColor.a));
                    Stroke oldstroke = gfx.getStroke();
                    gfx.setStroke(new BasicStroke(effectSize, 1, 1));
                    gfx.draw(layout.getOutline(null));
                    gfx.setStroke(oldstroke);
                }
                gfx.setColor(new Color(color.r, color.g, color.b, color.a));
                gfx.fill(layout.getOutline(null));
                if (effectSize == 1) {
                    gfx.setColor(new Color(effectColor.r, effectColor.g, effectColor.b, effectColor.a));
                    gfx.draw(layout.getOutline(null));
                }
            } else if (effect == 4) {
                BufferedImage img;
                char[] chars = origText.toCharArray();
                int ox = 0;
                for (char c : chars) {
                    img = this.getGlowBackground(c, size.height, effectColor, effectSize);
                    gfx.drawImage(img, null, ox, 0);
                    ox += img.getWidth() - effectSize * 2;
                }
                ox = effectSize;
                for (char c : chars) {
                    if (c == '\n' || c == '\r') continue;
                    img = this.getGlowForeground(c, size.height, color, effectSize);
                    gfx.drawImage(img, null, ox, 0);
                    ox += img.getWidth();
                }
            } else {
                Composite ocomp = gfx.getComposite();
                if (this._antialias) {
                    gfx.setComposite(AlphaComposite.SrcOut);
                    if (_isMacOS) {
                        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                }
                boolean dx = false;
                if (effect == 2) {
                    gfx.setColor(new Color(effectColor.r, effectColor.g, effectColor.b, effectColor.a));
                    float tx = effectSize - 1;
                    float ty = layout.getAscent() + (float)effectSize;
                    if (_isMacOS) {
                        gfx.translate(tx, ty);
                        gfx.fill(layout.getOutline(null));
                        gfx.translate(-tx, -ty);
                    } else {
                        layout.draw(gfx, tx, ty);
                    }
                    dx = true;
                    gfx.setComposite(ocomp);
                }
                gfx.setColor(new Color(color.r, color.g, color.b, color.a));
                if (_isMacOS) {
                    gfx.translate((double)dx, layout.getAscent());
                    gfx.fill(layout.getOutline(null));
                } else {
                    layout.draw(gfx, (float)dx, layout.getAscent());
                }
            }
            Object var21_28 = null;
        }
        catch (Throwable throwable) {
            Object var21_29 = null;
            gfx.dispose();
            throw throwable;
        }
        gfx.dispose();
        final Image image = new Image(bimage);
        return new Text(){

            public int getLength() {
                return length;
            }

            public Dimension getSize() {
                return size;
            }

            public int getHitPos(int x, int y) {
                TextHitInfo info = layout.hitTestChar(x, y);
                return info.getInsertionIndex();
            }

            public int getCursorPos(int index) {
                Shape[] carets = layout.getCaretShapes(index);
                Rectangle2D bounds = carets[0].getBounds2D();
                return (int)Math.round(bounds.getX() + bounds.getWidth() / 2.0);
            }

            public void render(Renderer renderer, int x, int y, float alpha) {
                image.render(renderer, x, y, alpha);
            }

            public void render(Renderer renderer, int x, int y, int w, int h, float alpha) {
                image.render(renderer, x, y, w, h, alpha);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage getGlowBackground(char c, int height, Color4f color, int effectSize) {
        BufferedImage image = this._cachedGlowBGs.get(this._gkey.init(c, color, effectSize));
        if (image != null) {
            return image;
        }
        image = new BufferedImage(this.computeWidth(c) + effectSize * 2, height, 6);
        Graphics2D gfx = image.createGraphics();
        try {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            TextLayout layout = new TextLayout(String.valueOf(c), this._attrs.get(TextAttribute.FONT), gfx.getFontRenderContext());
            float alphaScale = Math.max((float)effectSize, 2.0f) / 2.0f;
            gfx.setColor(new Color(color.r, color.g, color.b, color.a / alphaScale));
            gfx.translate((double)effectSize, layout.getAscent() + (float)effectSize);
            for (int ii = effectSize; ii > 0; --ii) {
                gfx.setStroke(new BasicStroke((float)effectSize * ((float)ii / (float)effectSize), 1, 0, 1.0f));
                gfx.draw(layout.getOutline(null));
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            gfx.dispose();
            throw throwable;
        }
        gfx.dispose();
        this._cachedGlowBGs.put(this._gkey.cloneKey(), image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage getGlowForeground(char c, int height, Color4f color, int effectSize) {
        BufferedImage image = this._cachedGlowFGs.get(this._gkey.init(c, color, effectSize));
        if (image != null) {
            return image;
        }
        image = new BufferedImage(this.computeWidth(c), height, 6);
        Graphics2D gfx = image.createGraphics();
        try {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            TextLayout layout = new TextLayout(String.valueOf(c), this._attrs.get(TextAttribute.FONT), gfx.getFontRenderContext());
            gfx.setColor(new Color(color.r, color.g, color.b, color.a));
            gfx.translate(0.0, layout.getAscent() + (float)effectSize);
            gfx.fill(layout.getOutline(null));
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            gfx.dispose();
            throw throwable;
        }
        gfx.dispose();
        this._cachedGlowFGs.put(this._gkey.cloneKey(), image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int computeWidth(char c) {
        int n;
        Graphics2D gfx = this._stub.createGraphics();
        try {
            TextLayout layout = new TextLayout(String.valueOf(c), this._attrs.get(TextAttribute.FONT), gfx.getFontRenderContext());
            n = (int)Math.ceil(layout.getAdvance());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            gfx.dispose();
            throw throwable;
        }
        gfx.dispose();
        return n;
    }

    protected AttributedString parseStyledText(String text, Map<TextAttribute, Font> attrs, String[] bare, boolean style) {
        StyleRun run;
        if (!style || !text.contains("@=")) {
            if (bare != null) {
                bare[0] = text;
            }
            return new AttributedString(text, attrs);
        }
        ArrayList<StyleRun> stack = new ArrayList<StyleRun>();
        ArrayList<StyleRun> runs = new ArrayList<StyleRun>();
        StringBuilder raw = new StringBuilder();
        int rawpos = 0;
        int ll = text.length();
        for (int ii = 0; ii < ll; ++ii) {
            char c = text.charAt(ii);
            if (c == ')') {
                if (stack.size() == 0) {
                    raw.append(c);
                    ++rawpos;
                    continue;
                }
                run = (StyleRun)stack.remove(0);
                run.end = rawpos;
                runs.add(run);
                continue;
            }
            if (c == '@') {
                if (ii >= ll - 5) {
                    raw.append(c);
                    ++rawpos;
                    continue;
                }
                if ((c = text.charAt(++ii)) != '=') {
                    if (c != '@' && c != '(' && c != ')') {
                        raw.append('@');
                        ++rawpos;
                    }
                    raw.append(c);
                    ++rawpos;
                    continue;
                }
            } else {
                raw.append(c);
                ++rawpos;
                continue;
            }
            run = new StyleRun();
            run.start = rawpos;
            stack.add(0, run);
            int parenidx = text.indexOf(40, ii);
            if (parenidx == -1) {
                Log.log.info((Object)("Invalid style specification, missing paren [text=" + text + ", pos=" + ii + "]."), new Object[0]);
                continue;
            }
            String styles = text.substring(ii + 1, parenidx);
            ii = parenidx;
            run.styles = new char[styles.length()];
            int ssl = styles.length();
            for (int ss = 0; ss < ssl; ++ss) {
                run.styles[ss] = Character.toLowerCase(styles.charAt(ss));
                if (run.styles[ss] != '#') continue;
                if (ss > ssl - 7) {
                    Log.log.warning((Object)("Invalid color definition [text=" + text + ", color=" + styles.substring(ss) + "]."), new Object[0]);
                    ss = ssl;
                    continue;
                }
                String hex = styles.substring(ss + 1, ss + 7);
                ss += 6;
                try {
                    run.color = new Color(Integer.parseInt(hex, 16));
                    continue;
                }
                catch (Exception e) {
                    Log.log.warning((Object)("Invalid color definition [text=" + text + ", color=#" + hex + "]."), new Object[0]);
                }
            }
        }
        String rawtext = raw.toString();
        if (bare != null) {
            bare[0] = rawtext;
        }
        AttributedString string = new AttributedString(rawtext, attrs);
        for (int ii = 0; ii < runs.size(); ++ii) {
            run = (StyleRun)runs.get(ii);
            if (run.styles == null) continue;
            block13: for (char runStyle : run.styles) {
                switch (runStyle) {
                    case '#': {
                        if (run.color == null) continue block13;
                        string.addAttribute(TextAttribute.FOREGROUND, run.color, run.start, run.end);
                        continue block13;
                    }
                    case 'i': {
                        string.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, run.start, run.end);
                        continue block13;
                    }
                    case 'b': {
                        string.addAttribute(TextAttribute.FONT, attrs.get(TextAttribute.FONT).deriveFont(1), run.start, run.end);
                        continue block13;
                    }
                    case 's': {
                        string.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, run.start, run.end);
                        continue block13;
                    }
                    case 'u': {
                        string.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, run.start, run.end);
                        continue block13;
                    }
                    case '\u0000': {
                        continue block13;
                    }
                    default: {
                        Log.log.info((Object)("Invalid style command [text=" + text + ", command=" + runStyle + ", run=" + run + "]."), new Object[0]);
                    }
                }
            }
        }
        return string;
    }

    static {
        try {
            String osname = StringUtil.deNull((String)System.getProperty("os.name"));
            _isMacOS = osname.contains("Mac OS") || osname.contains("MacOS");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class GlowKey
    implements Cloneable {
        public char c;
        public Color4f color;
        public int size;

        protected GlowKey() {
        }

        public GlowKey init(char c, Color4f color, int size) {
            this.c = c;
            this.color = color;
            this.size = size;
            return this;
        }

        public GlowKey cloneKey() {
            try {
                return (GlowKey)super.clone();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof GlowKey)) {
                return false;
            }
            GlowKey okey = (GlowKey)other;
            return this.c == okey.c && this.size == okey.size && this.color.equals(okey.color);
        }

        public int hashCode() {
            return this.c ^ this.size ^ this.color.hashCode();
        }
    }

    protected static class StyleRun {
        public char[] styles;
        public Color color;
        public int start;
        public int end;

        protected StyleRun() {
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (char style : this.styles) {
                if (style <= '\u0000') continue;
                buf.append(style);
            }
            if (this.color != null) {
                buf.append(":").append(Integer.toHexString(this.color.getRGB()));
            }
            buf.append(":").append(this.start).append("-").append(this.end);
            return buf.toString();
        }
    }
}

