/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.DimenInfo;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;

public class VGroupLayout
extends GroupLayout {
    public Dimension computePreferredSize(Container target, int whint, int hhint) {
        DimenInfo info = this.computeDimens(target, false, whint, hhint);
        Dimension dims = new Dimension();
        dims.height = this._policy == STRETCH ? info.maxfreehei * (info.count - info.numfix) + info.fixhei : (this._policy == EQUALIZE ? info.maxhei * info.count : info.tothei);
        dims.height += (info.count - 1) * this._gap;
        dims.width = info.maxwid;
        return dims;
    }

    public void layoutContainer(Container target) {
        int tothei;
        Rectangle b = target.getBounds();
        Insets insets = target.getInsets();
        b.width -= insets.getHorizontal();
        b.height -= insets.getVertical();
        DimenInfo info = this.computeDimens(target, false, b.width, b.height);
        int nk = target.getComponentCount();
        int totgap = this._gap * (info.count - 1);
        int freecount = info.count - info.numfix;
        int freefrac = 0;
        int defhei = 0;
        if (this._policy == STRETCH) {
            if (freecount > 0) {
                int freehei = b.height - info.fixhei - totgap;
                defhei = freehei / freecount;
                freefrac = freehei % freecount;
                tothei = b.height;
            } else {
                tothei = info.fixhei + totgap;
            }
        } else if (this._policy == EQUALIZE) {
            defhei = info.maxhei;
            tothei = info.fixhei + defhei * freecount + totgap;
        } else {
            tothei = info.tothei + totgap;
        }
        int defwid = 0;
        if (this._offpolicy == STRETCH) {
            defwid = b.width;
        } else if (this._offpolicy == EQUALIZE) {
            defwid = info.maxwid;
        }
        int sy = this._justification == LEFT || this._justification == BOTTOM ? insets.bottom + tothei : (this._justification == CENTER ? insets.bottom + b.height - (b.height - tothei) / 2 : insets.bottom + b.height);
        for (int i = 0; i < nk; ++i) {
            int newhei;
            if (info.dimens[i] == null) continue;
            Component child = target.getComponent(i);
            if (this._policy == NONE || this.isFixed(child)) {
                newhei = info.dimens[i].height;
            } else {
                newhei = defhei + freefrac;
                freefrac = 0;
            }
            int newwid = this._offpolicy == NONE ? info.dimens[i].width : (this._offpolicy == CONSTRAIN ? Math.min(info.dimens[i].width, b.width) : defwid);
            int sx = this._offjust == LEFT || this._offjust == TOP ? insets.left : (this._offjust == RIGHT || this._offjust == BOTTOM ? insets.left + (b.width - newwid) : insets.left + (b.width - newwid) / 2);
            child.setBounds(sx, sy - newhei, newwid, newhei);
            sy -= newhei + this._gap;
        }
    }
}

