/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Point;
import com.threerings.opengl.gui.util.Rectangle;
import java.util.HashMap;

public class AbsoluteLayout
extends LayoutManager {
    protected boolean _flipped;
    protected HashMap<Component, Object> _spots = new HashMap();

    public AbsoluteLayout() {
        this(false);
    }

    public AbsoluteLayout(boolean flipped) {
        this._flipped = flipped;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Point) {
            Point p = (Point)constraints;
            if (p.x < 0 || p.y < 0) {
                throw new IllegalArgumentException("Components must be laid out at positive coords: " + p);
            }
        } else if (constraints instanceof Rectangle) {
            Rectangle r = (Rectangle)constraints;
            if (r.x < 0 || r.y < 0) {
                throw new IllegalArgumentException("Components must be laid out at positive coords: " + r);
            }
            if (r.width < 0 || r.height < 0) {
                throw new IllegalArgumentException("Constraints must specify positive dimensions: " + r);
            }
        } else {
            throw new IllegalArgumentException("Components must be added to an AbsoluteLayout with Point or Rectangle constraints.");
        }
        this._spots.put(comp, constraints);
    }

    public void removeLayoutComponent(Component comp) {
        this._spots.remove(comp);
    }

    public Object getConstraints(Component comp) {
        return this._spots.get(comp);
    }

    public Dimension computePreferredSize(Container target, int whint, int hhint) {
        Rectangle rec = new Rectangle();
        int cc = target.getComponentCount();
        for (int ii = 0; ii < cc; ++ii) {
            Component comp = target.getComponent(ii);
            if (!comp.isVisible()) continue;
            Object cons = this._spots.get(comp);
            if (cons instanceof Point) {
                Point p = (Point)cons;
                Dimension d = comp.getPreferredSize(-1, -1);
                rec.add(p.x, p.y, d.width, d.height);
                continue;
            }
            if (!(cons instanceof Rectangle)) continue;
            Rectangle r = (Rectangle)cons;
            rec.add(r.x, r.y, r.width, r.height);
        }
        return new Dimension(rec.x + rec.width, rec.y + rec.height);
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int height = target.getHeight();
        int cc = target.getComponentCount();
        for (int ii = 0; ii < cc; ++ii) {
            Component comp = target.getComponent(ii);
            if (!comp.isVisible()) continue;
            Object cons = this._spots.get(comp);
            if (cons instanceof Point) {
                Point p = (Point)cons;
                Dimension d = comp.getPreferredSize(-1, -1);
                comp.setBounds(insets.left + p.x, this._flipped ? height - d.height - insets.top - p.y : insets.bottom + p.y, d.width, d.height);
                continue;
            }
            if (!(cons instanceof Rectangle)) continue;
            Rectangle r = (Rectangle)cons;
            comp.setBounds(insets.left + r.x, this._flipped ? height - r.height - insets.top - r.y : insets.bottom + r.y, r.width, r.height);
        }
    }
}

